package beans;

import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;

import java.util.*;

public class StockListBean implements SessionBean {
  
  // Mthodes publiques. Ces mthodes doivent galement 
  // tre dclares dans l'interface. 
  
  public ArrayList getStockRatings() {
    try {
      // Obtenir une contexte initial
      InitialContext initial = new InitialContext();
      // Obtenir une rfrence  l'interface home
      LocalStockHome home = (LocalStockHome)
        initial.lookup("java:comp/env/ejb/beans.Stock");
        
      // Obtenir les actions
      ArrayList stkList = new ArrayList();
      Collection stocks = home.findRatedStocks();
      Iterator i = stocks.iterator();
      while (i.hasNext()) {
        LocalStock stock = (LocalStock) i.next();
        String[] stockData = new String[4];
        stockData[0] = stock.getTickerSymbol();
        stockData[1] = stock.getName();
        stockData[2] = stock.getAnalystName();
        stockData[3] = stock.getRating();
        stkList.add(stockData);
      }
      
      return stkList;
    }
    catch (Exception e) {
      throw new EJBException(e.getMessage());
    }
  }
  
  public ArrayList getAllAnalysts() {
    try {
      // Obtenir un contexte initial
      InitialContext initial = new InitialContext();
      // Obtenir une rfrence  l'interface home
      LocalAnalystHome home = (LocalAnalystHome)
        initial.lookup("java:comp/env/ejb/beans.Analyst");
        
      // get the analysts
      ArrayList analystList = new ArrayList();
      Collection analysts = home.findAllAnalysts();
      Iterator i = analysts.iterator();
      while (i.hasNext()) {
        LocalAnalyst analyst = (LocalAnalyst) i.next();
        Object[] analystData = new Object[2];
        analystData[0] = analyst.getAnalystId();
        analystData[1] = analyst.getName();
        analystList.add(analystData);
      }
      
      return analystList;
    }
    catch (Exception e) {
      throw new EJBException(e.getMessage());
    }
  }
  
  public ArrayList getUnratedStocks() {
    try {
      // Obtenir un contexte initial
      InitialContext initial = new InitialContext();
      // Obtenir une rfrence  l'interface home
      LocalStockHome home = (LocalStockHome)
        initial.lookup("java:comp/env/ejb/beans.Stock");
        
      // Obtenir les actions juges
      Collection stocks = home.findRatedStocks();
      LocalStock[] ratedStocks = new LocalStock[stocks.size()];
      Iterator i = stocks.iterator();
      int ctr = 0;
      while (i.hasNext()) {
        LocalStock stock = (LocalStock) i.next();
        ratedStocks[ctr++] = stock;
      }
      
      // Obtenir toutes les actions
      Collection allStocks = home.findAllStocks();
      ArrayList stkList = new ArrayList();
      
      // Eliminer les actions juges
      Iterator j = allStocks.iterator();
      while (j.hasNext()) {
        LocalStock stock = (LocalStock) j.next();
        boolean rated = false;
        for (int k = 0; k < ratedStocks.length; k++) {
          String ratedTicker = ratedStocks[k].getTickerSymbol();
          if (stock.getTickerSymbol().equals(ratedTicker)) {
            rated = true;
            break;
          }
        }
        if (!rated) {
          stkList.add(stock.getTickerSymbol());
        }
      }
      
      return stkList;
    }
    catch (Exception e) {
      throw new EJBException(e.getMessage());
    }
  }
  
  public void addStockRating(String ticker, Integer analystId,
    String rating) {
    try {
      // Obtenir un contexte initial
      InitialContext initial = new InitialContext();
      // Obtenir une rfrence aux interfaces home
      LocalStockHome stockHome = (LocalStockHome)
        initial.lookup("java:comp/env/ejb/beans.Stock");
      LocalAnalystHome analystHome = (LocalAnalystHome)
        initial.lookup("java:comp/env/ejb/beans.Analyst");
      LocalStock stock = stockHome.findByPrimaryKey(ticker);
      // Obtenir les rfrences locales
      LocalAnalyst analyst = 
        analystHome.findByPrimaryKey(analystId);
      analyst.assignStock(stock);
      stock.setRating(rating);
    }
    catch (Exception e) {
      e.printStackTrace();
      throw new EJBException(e.getMessage());
    }
  }
  
  public void addAnalyst(Integer id, String name) {
    try {
      InitialContext initial = new InitialContext();
      // Obtenir une rfrence  l'interface home
      LocalAnalystHome analystHome = (LocalAnalystHome)
        initial.lookup("java:comp/env/ejb/beans.Analyst");
      analystHome.create(id, name);
    }
    catch (Exception e) {
      e.printStackTrace();
      throw new EJBException(e.getMessage());
    }
  }
  
  public void addStock(String ticker, String name) {
    try {
      InitialContext initial = new InitialContext();
      // Obtenir une rfrence  l'interface home
      LocalStockHome stockHome = (LocalStockHome)
        initial.lookup("java:comp/env/ejb/beans.Stock");
      stockHome.create(ticker, name);
    }
    catch (Exception e) {
      e.printStackTrace();
      throw new EJBException(e.getMessage());
    }
  }

  // Mthodes EJB standards
  public void ejbActivate() { }
  public void ejbPassivate() { }
  public void ejbRemove() { }
  public void ejbCreate() { }
  public void setSessionContext(SessionContext context) { }
}