package client;

import beans.StockList;
import beans.StockListHome;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class StockListAdder {

  public static void main(String[] args) {
    try {
      InitialContext jndiContext = new InitialContext();

      // Obtenir une rfrence  l'entre JNDI StockList
      Object ref  = jndiContext.lookup("ejb/beans.StockList");

      // Obtenir une rfrence  l'interface home du bean
      StockListHome home = (StockListHome)
        PortableRemoteObject.narrow(ref, StockListHome.class);

      // Crer un objet StockList  partir de l'interface home
      StockList stockList = home.create();

      // Ajoute des Analyst
      System.out.println("Ajout des experts...");
      stockList.addAnalyst(new Integer(1), "Fred");
      stockList.addAnalyst(new Integer(2), "Leonard");
      stockList.addAnalyst(new Integer(3), "Sarah");
      stockList.addAnalyst(new Integer(4), "Nancy");
      System.out.println("Ajout des experts OK");
    }
    catch (Exception e) {
      System.out.println("Exception lors de l'ajout des experts");
      e.printStackTrace();
    }

    try {
      InitialContext jndiContext = new InitialContext();

      // Obtenir une rfrence  l'entre JNDI StockList
      Object ref  = jndiContext.lookup("ejb/beans.StockList");

      // Obtenir une rfrence  l'interface home du bean
      StockListHome home = (StockListHome)
        PortableRemoteObject.narrow(ref, StockListHome.class);

      // Crer un objet StockList  partir de l'interface home
      StockList stockList = home.create();

      // Ajout des actions
      System.out.println("Ajout des actions...");
      stockList.addStock("ABC", "ABC Company");
      stockList.addStock("ZZZ", "Zigby Zebras");
      stockList.addStock("ICS", "Internet Corp of Slobovia");
      stockList.addStock("DDC", "Digby Door Company");
      stockList.addStock("ZAP", "Zapalopalorinski Ltd.");
      stockList.addStock("JIM", "Jimco");
      stockList.addStock("SRU", "Stocks R Us");
      stockList.addStock("SRI", "Shelves and Radios Inc");
      stockList.addStock("FBC", "Foo Bar Company");
      stockList.addStock("DDBC", "Ding Dong Bell Company");
      stockList.addStock("UDE", "Upn Down Elevator Company");
      System.out.println("Ajout des actions OK");
    }
    catch (Exception e) {
      System.out.println("Exception lors de l'ajout des actions");
      e.printStackTrace();
    }

    try {
      InitialContext jndiContext = new InitialContext();

      // Obtenir une rfrence  l'entre JNDI StockList
      Object ref  = jndiContext.lookup("ejb/beans.StockList");

      // Obtenir une rfrence  l'interface home du bean
      StockListHome home = (StockListHome)
        PortableRemoteObject.narrow(ref, StockListHome.class);

      // Crer un objet StockList  partir de l'interface home
      StockList stockList = home.create();

      // Ajout des jugements
      System.out.println("Ajout des jugements...");
      stockList.addStockRating("ZZZ", new Integer(2),
        "A tenter !");
      System.out.println("Ajout des jugements OK");
    }
    catch (Exception e) {
      System.out.println("Exception lors de l'ajout des jugements");
      e.printStackTrace();
    }
  }
}