package beans;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;

import java.util.*;

public abstract class AnalystBean implements EntityBean {

  // keeps the reference to the context
  private EntityContext _context;

  // the abstract access methods for persistent fields
  public abstract Integer getAnalystId();
  public abstract void setAnalystId(Integer id);
  
  public abstract String getName();
  public abstract void setName(String name);

  // the abstract access methods for cmr fields
  public abstract Collection getStocks();
  public abstract void setStocks(Collection stocks);
  
  // business methods
  public void assignStock(LocalStock stock) {
    try {
      Collection stocks = getStocks();
      stocks.add(stock);
    } catch (EJBException ex) {
      ex.printStackTrace();
      throw ex;
    }
  }
  
  // standard entity bean methods

  public Integer ejbCreate(Integer id, String name)
    throws CreateException {

    setAnalystId(id);
    setName(name);
    return null;
  }
         
  public void ejbPostCreate(Integer id, String name)
    throws CreateException { }

  public void setEntityContext(EntityContext ctx) {
      _context = ctx;
  }
    
  public void unsetEntityContext() {
      _context = null;
  }
    
  public void ejbRemove() { }
  public void ejbLoad() { }
  public void ejbStore() { }
  public void ejbPassivate() { }
  public void ejbActivate() { }
}