package beans;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;

public abstract class StockBean implements EntityBean {

  // keeps the reference to the context
  private EntityContext _context;

  // the abstract access methods for persistent fields
  public abstract String getTickerSymbol();
  public abstract void setTickerSymbol(String ticker);

  public abstract String getName();
  public abstract void setName(String name);

  public abstract String getRating();
  public abstract void setRating(String rating);

  // the abstract access methods for cmr fields
  public abstract LocalAnalyst getAnalyst();
  public abstract void setAnalyst(LocalAnalyst analyst);

  // the abstract ejbSelect methods
  public abstract String ejbSelectAnalyst(String ticker)
    throws FinderException;

  // business methods
  public String getAnalystName() throws FinderException {
    return ejbSelectAnalyst(getTickerSymbol());
  }

  // standard entity bean methods

  public String ejbCreate(String ticker, String name)
    throws CreateException {

    setTickerSymbol(ticker);
    setName(name);
    return null;
  }

  public void ejbPostCreate(String ticker, String name)
    throws CreateException { }

  public void setEntityContext(EntityContext ctx) {
      _context = ctx;
  }

  public void unsetEntityContext() {
      _context = null;
  }

  public void ejbRemove() { }
  public void ejbLoad() { }
  public void ejbStore() { }
  public void ejbPassivate() { }
  public void ejbActivate() { }
}