package client;

import facade.StockListFacade;
import vo.AnalystVo;
import vo.StockVo;

public class StockListAdder {

  public static void main(String[] args) {
    try {
      StockListFacade facade = StockListFacade.getFacade();

      // Ajouter des experts
      System.out.println("Ajout des experts...");

      facade.addAnalyst(new AnalystVo(new Integer(1), "Fred"));
      facade.addAnalyst(new AnalystVo(new Integer(2), "Leonard"));
      facade.addAnalyst(new AnalystVo(new Integer(3), "Sarah"));
      facade.addAnalyst(new AnalystVo(new Integer(4), "Nancy"));
      System.out.println("Ajout des experts OK");
    }
    catch (Exception e) {
      System.out.println("Exception lors de l'ajout des experts");
      e.printStackTrace();
    }

    try {
      StockListFacade facade = StockListFacade.getFacade();

      // Ajout des actions
      System.out.println("Ajout des actions...");
      facade.addStock(new StockVo("ABC", "ABC Company", null));
      facade.addStock(new StockVo("ZZZ", "Zigby Zebras", null));
      facade.addStock(new StockVo("ICS", "Internet Corp of Slobovia", null));
      facade.addStock(new StockVo("DDC", "Digby Door Company", null));
      facade.addStock(new StockVo("ZAP", "Zapalopalorinski Ltd.", null));
      facade.addStock(new StockVo("JIM", "Jimco", null));
      facade.addStock(new StockVo("SRU", "Stocks R Us", null));
      facade.addStock(new StockVo("SRI", "Shelves and Radios Inc", null));
      facade.addStock(new StockVo("FBC", "Foo Bar Company", null));
      facade.addStock(new StockVo("DDBC", "Ding Dong Bell Company", null));
      facade.addStock(new StockVo("UDE", "Upn Down Elevator Company", null));
      System.out.println("Ajout des actions OK");
    }
    catch (Exception e) {
      System.out.println("Exception lors de l'ajout des actions");
      e.printStackTrace();
    }

    try {
      StockListFacade facade = StockListFacade.getFacade();

      // Ajout des apprciations
      System.out.println("Ajout des appreciations...");
      StockVo stockVo = new StockVo("ZZZ", null, "Take a chance!");
      stockVo.setAnalyst(new AnalystVo(new Integer(2), null));
      facade.addStockRating(stockVo);
      System.out.println("Ajout des apprciations OK");
    }
    catch (Exception e) {
      System.out.println("Exception lors de l'ajout des apprciations");
      e.printStackTrace();
    }
  }
}