package client;

import webservices.SimpleServiceIF;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;

public class SimpleServiceClient { 
  public static void main(String[] args) {
    try {
      String serviceName = "SimpleBeanService";
      String urlString = 
        "http://localhost:8080/simplebean?WSDL";
      String nameSpaceUri = 
                "urn:simpleBeanService";
      String portName = "SimpleServiceIFPort";

      URL wsdlUrl = new URL(urlString);
            
      ServiceFactory serviceFactory = ServiceFactory.newInstance();
            
      Service jaxService =
        serviceFactory.createService(wsdlUrl, 
                new QName(nameSpaceUri, serviceName));
            
      SimpleServiceIF myProxy = (SimpleServiceIF) jaxService.getPort(
                new QName(nameSpaceUri, portName), 
                SimpleServiceIF.class); 

      System.out.println("Service contacte !");
      
      // Boucle sur les mots
      for (int i = 0; i < args.length; i++) {
        String returnedString =
          myProxy.getEchoString(args[i]);
        System.out.println("Chaine envoyee : " + args[i]
          + ", chaine retournee : " + returnedString);
      }
    } catch(Exception e) {
      e.printStackTrace();
    }
  }
}