package Ch04;

import java.util.*;
import javax.servlet.jsp.tagext.*;
import javax.servlet.jsp.*;
import java.io.*;

public class ListQuestions extends TagSupport {
  private String topic;
  private Iterator faqs;
  private int count;

  public void setTopic(String s) { topic = s; }
  public String getTopic() { return topic; }

  public int doStartTag() throws JspTagException {
    Questions questions = new Questions();
    questions.setTopic(getTopic());
    Map qmap = new TreeMap(questions.getQuestions());

    // Obtention d'un itrateur pour les questions
    // L'Iterator doit tre une variable d'instance car nous voulons
    // pouvoir y accder dans la mthode doAfterBody()
    faqs = qmap.values().iterator();
    count = 0;
    try {
      // Ecriture du texte prliminaire dans la rponse
      pageContext.getOut().write("<h2>Questions de la catgories " + 
                                      getTopic() + "</h2>");
      pageContext.getOut().write("\nCette catgorie comporte " 
                                 + qmap.size() + " questions.");

    } catch (IOException e) {
      throw new JspTagException("Erreur pendant l'criture de la rponse");
    }
    return EVAL_BODY_INCLUDE;
  }

  public int doAfterBody() throws JspTagException {
    // Cration du lien pour une question
    // A chaque appel de cette mthode par la page,
    // l'Iterator passe  la question suivante.
    if (faqs.hasNext()) {
      String question = (String) faqs.next();
      String s = "<p>Question <a href=\"Questions.jsp?qid=" + getTopic() +
        "_" + ++count + "\">" + getTopic() + "_" + count + "</a>: " + 
        question + "</p>";
      try {
        pageContext.getOut().write(s);
      } catch (IOException e) {
        throw new JspTagException("Erreur pendant l'criture de la rponse");
      }
      // Indique  la page qu'elle doit valuer de nouveau le corps
      return EVAL_BODY_AGAIN;
    } else {
      // faqs.next() retourne false, indiquant qu'il n'y a plus de questions
      return SKIP_BODY;
    }
  }

  public int doEndTag() throws JspTagException {
    try {
      pageContext.getOut().write("<p>Cliquez sur un lien " 
                                 + "pour obtenir la rponse.</p>");
    } catch (IOException e) {
      throw new JspTagException("Erreur pendant l'criture de la rponse");
    }
    return EVAL_PAGE;
  }
}

