<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<%@ taglib uri="http://java.sun.com/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jstl/format" prefix="fmt" %>

<html>
  <head>
    <title>JSTL Q2</title>
  </head>

  <body>
    <h1>JSTL Question 2</h1>
    <h2>Comment utilise-t-on JSTL&nbsp;?</h2>

    <jsp:useBean id="questions" class="Ch04.Questions">
      <jsp:setProperty name="questions" property="topic" value="EL"/>
    </jsp:useBean>

    <table border="1">
      <!-- La balise JSTL figurera dans la colonne gauche de la table -->
      <!-- La valeur value par la balise JSTL sera dans la colonne de droite -->
      <tr><th>Balise</th><th>Rsultat</th></tr>

      <!-- Cette balise utilise c:out pour envoyer le rsultat d'une EL
            la rponse -->

      <tr>
        <td>&lt;c:out value="${'${'}questions.topic}"/&gt;</td>
        <td><c:out value="questions.topic=${questions.topic}"/></td>
      </tr>

      <!-- Cette balise utilise c:set pour modifier la proprit d'un Java Bean -->
      <tr>
        <td>
          &lt;c:set target="${'${'}questions}" property="topic"
                       value="JSTL" /&gt;
          <c:set target="${questions}" property="topic" value="JSTL" />
        </td>
        <td><c:out value="questions.topic=${questions.topic}"/></td>
      </tr>

      <!-- Cette balise c:if pour dterminer si une nouvelle ligne doit tre
           ajoute  la table -->
      <c:if test="${questions.topic} == 'EL'">
        <tr><td>Cette ligne ne sera pas ajoute.</td><td></td></tr>
      </c:if>

      <c:if test="${questions.topic == 'JSTL'}">
        <tr>
          <td>Cette ligne est ajoute parce que la balise c:if retourne true</td>
          <td></td>
        </tr>
      </c:if>
    </table>

    <p>Table de multiplication, 1 - 5</p>

    <!-- Utilisation de la balise forEach pour crer une table -->
    <table border="1">
      <tr>
        <td></td><td>1</td><td>2</td><td>3</td><td>4</td><td>5</td>
      </tr>
      <c:forEach var="i" begin="1" end="5">
        <tr>
          <td><c:out value="${i}"/></td>
          <c:forEach var="j" begin="1" end="5">
            <td><c:out value="${i*j}"/></td>
          </c:forEach>
        </tr>
      </c:forEach>
    </table>

    <h2>Mise en forme des nombres</h2><br>
    &lt;fmt:formatNumber value="23.456" type="number" /&gt; 
    donne <fmt:formatNumber value="23.456" type="number" /><br>

    <fmt:setLocale value="fr_FR" />
    &lt;fmt:formatNumber type="currency"&gt;23.456&lt;/fmt:formatNumber&gt;
    donne <fmt:formatNumber type="currency"
                            currencySymbol="" >23.456</fmt:formatNumber>

    <br>&lt;fmt:formatNumber value=".23456" type="percent"/&gt; 
    donne <fmt:formatNumber value=".23456" type="percent"/><br>

    &lt;fmt:formatNumber value=".23456" type="percent"
                         minFractionDigits="2" /&gt;
    donne <fmt:formatNumber value=".23456" type="percent"
                                 minFractionDigits="2" />

  </body>
</html>
