package Ch07;

import java.sql.*;

public class JDBCClient5 {
  static Connection conn = null;
  static PreparedStatement pstmt = null;
  static ResultSet rset = null;

  static String sqlInsert =
    "insert into COUNTRIES "
      + "(COUNTRY, COUNTRY_ISO_CODE, REGION) "
      + "values (?, ?, ?)";

  static String sqlQuery = "select * from COUNTRIES";

  public static void main(String[] args) {
    try {
      String url = "jdbc:pointbase:server://localhost/pointbaseDB";
      String username = "PBPUBLIC";
      String password = "PBPUBLIC";
      conn = JDBCManager.getConnection(url, username, password, false);
      pstmt = conn.prepareStatement(sqlInsert);

      // Dbut de la transaction
      cleanupTable();
      doEUBatch();
      doNABatch();
      System.out.println(
        "\nVerification de la table avant " + "validation ou annulation :");
      doQuery();

      // Simulation de la ncessit d'une annulation
      JDBCManager.rollback(conn);
      System.out.println("\nVerification de la table apres annulation :");
      doQuery();
      JDBCManager.close(pstmt);

      pstmt = conn.prepareStatement(sqlInsert);
      doEUBatch();
      doNABatch();
      conn.commit();
      System.out.println("\nVerification de la table apres validation :");
      doQuery();
    } catch (SQLException e) {

      // Une exception indique que quelque chose a chou. Annulation.
      JDBCManager.rollback(conn);
      e.printStackTrace();
    } finally {
      JDBCManager.close(rset);
      JDBCManager.close(pstmt);
      JDBCManager.close(conn);
    }
  }

  public static void cleanupTable() {
    // Effacement des donnes ventuellement prsentes dans la table
    Statement stmt = null;

    try {
      stmt = conn.createStatement();
      stmt.executeUpdate("delete from COUNTRIES");
      conn.commit();
      System.out.println("La base de donnees a ete videe.");
    } catch (Exception e) {
      JDBCManager.rollback(conn);
    } finally {
      JDBCManager.close(stmt);
    }
  }

  public static void doEUBatch() throws SQLException {
    pstmt.setString(1, "Kyrgyzstan");
    pstmt.setString(2, "KG");
    pstmt.setString(3, "Asie");
    pstmt.addBatch();

    pstmt.setString(1, "Grande Bretagne");
    pstmt.setString(2, "GB");
    pstmt.setString(3, "Europe");
    pstmt.addBatch();

    pstmt.setString(1, "France");
    pstmt.setString(2, "FR");
    pstmt.addBatch();

    pstmt.executeBatch();
  }

  public static void doNABatch() throws SQLException {
    pstmt.setString(1, "Etats-Unis");
    pstmt.setString(2, "US");
    pstmt.setString(3, "Amerique du Nord");
    pstmt.addBatch();

    pstmt.setString(1, "Canada");
    pstmt.setString(2, "CA");
    pstmt.addBatch();

    pstmt.executeBatch();
  }

  public static void doQuery() throws SQLException {
    Statement stmt = null;
    try {
      stmt = conn.createStatement();
      rset = stmt.executeQuery(sqlQuery);
      int rownum = 1;
      if (rset.next()) {
        do {
          System.out.print("Ligne " + rownum++ +" : ");
          System.out.print(rset.getString(1) + ", ");
          System.out.print(rset.getString(2) + ", ");
          System.out.println(rset.getString(3));

        } while (rset.next());
      } else {
        System.out.println("Pas de donnees dans la table");
      }
    } catch (SQLException e) {
      e.printStackTrace();
    } finally {
      JDBCManager.close(rset);
      JDBCManager.close(stmt);
    }
  }
}