package Ch07;

import java.sql.*;

public class PessimisticLockerA {
  static Connection conn;
  static Statement stmt;
 

  static Statement stmtA;
  static PreparedStatement pstmt;
  static ResultSet rsetA;

  static String sqlCreate = "create table RESERVE " +
    "(ROOMID varchar(5), RES_DATE date, RES_FLAG boolean, " +
    "RES_NAME varchar(30))";
  static String sqlInsert = "insert into RESERVE values " +
    "(?, ?, ?, ?)";
  static String sqlUpdate = "update RESERVE set RES_FLAG=?, " +
    "RES_NAME=? WHERE ROOMID=? AND RES_DATE=?";
  static String sqlSelect = "select ROOMID, RES_DATE, " +
    "RES_FLAG, RES_NAME from RESERVE WHERE RES_FLAG=false FOR UPDATE";

  static String roomName;
  static java.sql.Date roomDate;

  public static void main(String[] args) {
    try {
      String url = "jdbc:pointbase:server://localhost/pointbaseDB";
      String username = "PBPUBLIC";
      String password = "PBPUBLIC";
      conn = JDBCManager.getConnection(url, username, password, false);
      System.out.println("conn autocommit : " + conn.getAutoCommit());
      setup();
      userAQuery();
      System.out.println("Interruption de 15 secondes. " +
                         "Lancez PessimisticLockerB");
      try {Thread.sleep(15000);} catch (Exception e) {} 
        System.out.println("PessimisticLockerA est actif");
        userAUpdate();
      } catch (Exception e) {
        e.printStackTrace();
      } finally {
        JDBCManager.close(conn);
    }
  }

  static void setup() throws SQLException {
    System.out.println("Creation de la table RESERVE");
    try {
      stmt = conn.createStatement();
      stmt.addBatch(sqlCreate);
      stmt.executeBatch();
      System.out.println("Insertion d'une ligne de donnees");
      pstmt = conn.prepareStatement(sqlInsert);
      pstmt.setString(1, "PIKE");
      pstmt.setDate(2, new java.sql.Date(System.currentTimeMillis()));
      pstmt.setBoolean(3,false);
      pstmt.setNull(4, java.sql.Types.VARCHAR);
      pstmt.executeUpdate();
      conn.commit();
    } finally {
      JDBCManager.close(pstmt);
 

      JDBCManager.close(stmt);
    }
  }

  static void userAQuery() throws SQLException {
    System.out.println("L'utilisateur A demande une chambre");
    stmtA = conn.createStatement();
    rsetA = stmtA.executeQuery(sqlSelect);
    if (rsetA.next()) {
      System.out.println("La requete retourne une ligne");
      roomName = rsetA.getString(1);
      roomDate = rsetA.getDate(2);
    }
    // Ni l'objet Statement ni l'objet ResultSet ne sont ferms ici
    // Ils doivent rester ouvert userAUpdate()
  }

  static void userAUpdate() throws SQLException {
    try {
      if (roomName != null && roomDate != null) {
        System.out.println("L'utilisateur A tente de reserver la chambre");
        pstmt = conn.prepareStatement(sqlUpdate);
        pstmt.setBoolean(1, true);
        pstmt.setString(2, "Utilisateur A");
        pstmt.setString(3,roomName);
        pstmt.setDate(4, roomDate);
        int result = pstmt.executeUpdate();
        if (result == 0) {
          System.out.println("La reservation n'a PAS reussi !");
          System.out.println("L'utilisateur devra essayer avec " +
                             "une autre chambre ou une autre date");
        } else {
          System.out.println("Validation pour l'utilisateur A");
          conn.commit();
        }
      }
    } catch (SQLException e) {
      e.printStackTrace(DriverManager.getLogWriter());
      System.out.println(e.getErrorCode());
      System.out.println(e.getMessage());
    } finally {
      JDBCManager.close(pstmt);
      JDBCManager.close(rsetA);
      JDBCManager.close(stmtA);
    }
  }
}
