package beans;

import java.rmi.RemoteException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class CalculatorBean implements SessionBean {
  // Rsultat des calculs
  private int _value = 0;
  
  // Mthodes publiques du bean Calculator. Ces mthodes 
  // doivent galement tre dclares dans l'interface. 
  
  // Remise  0 de la calculatrice
  public void clearIt() {
    _value = 0;
  }
  
  // Ajouter ou soustraire
  public void calculate(String operation, int value)
    throws RemoteException {    
    // Si "+", ajouter
    if (operation.equals("+")) {
      _value = _value + value;
      return;
    }
    
    // Si "-", soustraire
    if (operation.equals("-")) {
      _value = _value - value;
      return;
    }    
    
    // Si ni "+" ni "-", l'opration n'est pas valide    
    throw new RemoteException("Invalid Operation");
  }
  
  // Retourner la valeur
  public int getValue() throws RemoteException {
    return _value;
  }

  // Mthodes EJB standards
  public void ejbActivate() {}
  public void ejbPassivate() {}
  public void ejbRemove() {}
  public void ejbCreate() {}
  public void setSessionContext(SessionContext context) { }
}