package client;

import beans.SimpleSession;
import beans.SimpleSessionHome;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class SimpleSessionClient { 
  public static void main(String[] args) {
    try {
      // Obtention d'un contexte
      InitialContext jndiContext = new InitialContext();

      // Obtention d'une rfrence  l'entre JNDI SimpleSession
      Object ref  = jndiContext.lookup("ejb/beans.SimpleSession");

      // Obtention d'une rfrence  l'interface home du bean
      SimpleSessionHome home = (SimpleSessionHome)
       PortableRemoteObject.narrow(ref, SimpleSessionHome.class);

      // Cration d'un objet SimpleSession  partir de l'interface home
      SimpleSession simpleSession = home.create();
      
      // Traitement des mots
      for (int i = 0; i < args.length; i++) {
        String returnedString = simpleSession.getEchoString(args[i]);
        System.out.println("Chaine envoyee : " + args[i] +
						   ", chaine recue : " + returnedString);
      }
    } catch(Exception e) {
      e.printStackTrace();
    }
  }
}