package beans;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;

public abstract class StockBean implements EntityBean {

  // Rfrence au contexte
  private EntityContext _context;

  // Mthodes abstraites des champs persistants
  public abstract String getTickerSymbol();
  public abstract void setTickerSymbol(String ticker);

  public abstract String getName();
  public abstract void setName(String name);

  public abstract String getRating();
  public abstract void setRating(String rating);

  // Mthodes abstraites des champs CMR
  public abstract LocalAnalyst getAnalyst();
  public abstract void setAnalyst(LocalAnalyst analyst);

  // Mthodes abstraites ejbSelect
  public abstract String ejbSelectAnalyst(String ticker)
    throws FinderException;

  // Mthodes applicatives
  public String getAnalystName() throws FinderException {
    return ejbSelectAnalyst(getTickerSymbol());
  }

  // Mthodes standards des beans entits

  public String ejbCreate(String ticker, String name)
    throws CreateException {

    setTickerSymbol(ticker);
    setName(name);
    return null;
  }

  public void ejbPostCreate(String ticker, String name)
    throws CreateException { }

  public void setEntityContext(EntityContext ctx) {
      _context = ctx;
  }

  public void unsetEntityContext() {
      _context = null;
  }

  public void ejbRemove() { }
  public void ejbLoad() { }
  public void ejbStore() { }
  public void ejbPassivate() { }
  public void ejbActivate() { }
}