package beans;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

import java.util.*;

public class StockListBean implements SessionBean {
  
  // Mthodes publiques. Ces mthodes doivent galement 
  // tre dclares dans l'interface. 
  
  public ArrayList getStockRatings() {
    try {
      // Obtenir une contexte initial
      InitialContext initial = new InitialContext();
      // Obtenir une rfrence  l'interface home
      LocalStockHome home = (LocalStockHome)
        initial.lookup("java:comp/env/ejb/beans.Stock");
        
      // Obtenir les actions
      ArrayList stkList = new ArrayList();
      Collection stocks = home.findRatedStocks();
      Iterator i = stocks.iterator();
      while (i.hasNext()) {
        LocalStock stock = (LocalStock) i.next();
        String[] stockData = new String[4];
        stockData[0] = stock.getTickerSymbol();
        stockData[1] = stock.getName();
        stockData[2] = stock.getAnalystName();
        stockData[3] = stock.getRating();
        stkList.add(stockData);
      }
      
      return stkList;
    }
    catch (Exception e) {
      throw new EJBException(e.getMessage());
    }
  }
  
  public ArrayList getAllAnalysts() {
    try {
      // Construire la requte SQL
      StringBuffer sql = new StringBuffer();
      sql.append("SELECT analystId, name ");
      sql.append("FROM AnalystEjb ");
      sql.append("ORDER BY name");
        
      // Obtenir une connexion  la base de donnes  
      Connection conn = makeConnection();
      Statement stmt = conn.createStatement();
      ResultSet results = stmt.executeQuery(sql.toString());
      
      // Obtenir la liste des experts
      ArrayList analystList = new ArrayList();
      while (results.next()) {
        Object[] analystData = new Object[2];
        analystData[0] = new Integer(results.getInt(1));
        analystData[1] = results.getString(2);
        analystList.add(analystData);
      }
      
      results.close();
      stmt.close();
      conn.close();
      
      return analystList;
    }
    catch (Exception ex) {
      throw new RuntimeException(ex.getMessage());
    }  }
  
  public ArrayList getUnratedStocks() {
    try {
      // Obtenir un contexte initial
      InitialContext initial = new InitialContext();
      // Obtenir une rfrence  l'interface home
      LocalStockHome home = (LocalStockHome)
        initial.lookup("java:comp/env/ejb/beans.Stock");
        
      // Obtenir les actions juges
      Collection stocks = home.findRatedStocks();
      LocalStock[] ratedStocks = new LocalStock[stocks.size()];
      Iterator i = stocks.iterator();
      int ctr = 0;
      while (i.hasNext()) {
        LocalStock stock = (LocalStock) i.next();
        ratedStocks[ctr++] = stock;
      }
      
      // Obtenir toutes les actions
      Collection allStocks = home.findAllStocks();
      ArrayList stkList = new ArrayList();
      
      // Elminer les actions juges
      Iterator j = allStocks.iterator();
      while (j.hasNext()) {
        LocalStock stock = (LocalStock) j.next();
        boolean rated = false;
        for (int k = 0; k < ratedStocks.length; k++) {
          String ratedTicker = ratedStocks[k].getTickerSymbol();
          if (stock.getTickerSymbol().equals(ratedTicker)) {
            rated = true;
            break;
          }
        }
        if (!rated) {
          stkList.add(stock.getTickerSymbol());
        }
      }
      
      return stkList;
    }
    catch (Exception e) {
      throw new EJBException(e.getMessage());
    }
  }
  
  public void addStockRating(String ticker, Integer analystId,
    String rating) {
    try {
      // Obtenir un contexte initial
      InitialContext initial = new InitialContext();
      // Obtenir une rfrence aux interfaces home
      LocalStockHome stockHome = (LocalStockHome)
        initial.lookup("java:comp/env/ejb/beans.Stock");
      LocalAnalystHome analystHome = (LocalAnalystHome)
        initial.lookup("java:comp/env/ejb/beans.Analyst");
      LocalStock stock = stockHome.findByPrimaryKey(ticker);
      // Obtenir les rfrences locales
      LocalAnalyst analyst = 
        analystHome.findByPrimaryKey(analystId);
      analyst.assignStock(stock);
      stock.setRating(rating);
    }
    catch (Exception e) {
      e.printStackTrace();
      throw new EJBException(e.getMessage());
    }
  }
  
  public void addAnalyst(Integer id, String name) {
    try {
      InitialContext initial = new InitialContext();
      // Obtenir une rfrence  l'interface home
      LocalAnalystHome analystHome = (LocalAnalystHome)
        initial.lookup("java:comp/env/ejb/beans.Analyst");
      analystHome.create(id, name);
    }
    catch (Exception e) {
      e.printStackTrace();
      throw new EJBException(e.getMessage());
    }
  }
  
  public void addStock(String ticker, String name) {
    try {
      InitialContext initial = new InitialContext();
      // Obtenir une rfrence  l'interface home
      LocalStockHome stockHome = (LocalStockHome)
        initial.lookup("java:comp/env/ejb/beans.Stock");
      stockHome.create(ticker, name);
    }
    catch (Exception e) {
      e.printStackTrace();
      throw new EJBException(e.getMessage());
    }
  }

  private Connection makeConnection()
    throws NamingException, SQLException {

    InitialContext ic = new InitialContext();
    DataSource ds =
      (DataSource) ic.lookup("java:comp/env/jdbc/StockDB");
    return ds.getConnection();
  }

  // Mthodes EJB standards
  public void ejbActivate() { }
  public void ejbPassivate() { }
  public void ejbRemove() { }
  public void ejbCreate() { }
  public void setSessionContext(SessionContext context) { }
}