package client;

import beans.StockList;
import beans.StockListHome;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

import java.util.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class StockClient extends JFrame 
  implements ActionListener { 
  private StockList _stockList;
  private Integer[] _analystIds;
  private JButton _get = new JButton("Ajouter une apprciation");
  private JPanel _stockPanel = new JPanel();
  private JComboBox _analysts = new JComboBox();
  private JComboBox _tickers = new JComboBox();
  private JComboBox _ratings = new JComboBox();
      
  public StockClient() {

    _stockList = getStockList();
    
    // Ajout du titre
    JLabel title = new JLabel("Liste des apprciations");
    title.setHorizontalAlignment(JLabel.CENTER);
    getContentPane().add(title, BorderLayout.NORTH);
    
    JPanel activityPanel = new JPanel(new BorderLayout());
    try {
      // Ajout de la liste des actions
      buildStockList();
      JScrollPane scroller = new JScrollPane(_stockPanel);
      activityPanel.add(scroller, BorderLayout.CENTER);
      
      // Panneau des apprciation
      JPanel ratingPanel = new JPanel(new GridLayout(1, 3));
      // Ajout des analyste
      populateAnalysts();
      ratingPanel.add(_analysts);
      // Ajout des actions sans apprciation
      populateTickers();
      ratingPanel.add(_tickers);
      // Ajout des apprciations
      _ratings.addItem("A fuir !");
      _ratings.addItem("Pourrait tre pire !");
      _ratings.addItem("Moyen");
      _ratings.addItem("A tenter !");
      _ratings.addItem("Incontournable !");
      ratingPanel.add(_ratings);
      activityPanel.add(ratingPanel, BorderLayout.SOUTH);
      
      getContentPane().add(activityPanel, BorderLayout.CENTER);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
    
    // Ajout des boutons
    JPanel buttons = new JPanel(new GridLayout(1, 1));
    _get.addActionListener(this);
    buttons.add(_get);
    getContentPane().add(buttons, BorderLayout.SOUTH);
    
    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        System.exit(0);
      }
    });

    setSize(480, 250);
    setVisible(true);
  }
  
  private void buildStockList() throws Exception {
    ArrayList stoks = _stockList.getStockRatings();
    _stockPanel.removeAll();
    _stockPanel.setLayout(new GridLayout(stoks.size(), 1));
    for (int i = 0; i < stoks.size(); i++) {
      String[] stokInfo = (String[]) stoks.get(i);
      Box stokLine = Box.createHorizontalBox();
      String stokDesc = stokInfo[0] + " : " + stokInfo[1]
        + " ==> " + stokInfo[2] + " note cette action : " + stokInfo[3];
      stokLine.add(new JLabel(stokDesc));
      _stockPanel.add(stokLine);
    }
    _stockPanel.invalidate();
    _stockPanel.validate();
  }
  
  private void populateAnalysts() throws Exception {
    ArrayList anlysts = _stockList.getAllAnalysts();
    _analystIds = new Integer[anlysts.size()];
    for (int i = 0; i < anlysts.size(); i++) {
      Object[] analystData = (Object[]) anlysts.get(i);
      _analystIds[i] = (Integer) analystData[0];
      _analysts.addItem((String) analystData[1]);
    }
  }
  
  private void populateTickers() throws Exception {
    _tickers.removeAllItems();
    ArrayList tkrs = _stockList.getUnratedStocks();
    for (int i = 0; i < tkrs.size(); i++) {
      String ticker = (String) tkrs.get(i);
      _tickers.addItem(ticker);
    }
    _tickers.invalidate();
    _tickers.validate();
  }
  
  private StockList getStockList() {
    StockList stockList = null;
    try {
      // Contexte initial
      InitialContext jndiContext = new InitialContext();

      // Obtenir une rfrence  l'entre JNDI StockList
      Object ref  = jndiContext.lookup("ejb/beans.StockList");

      // Obtenir une rfrence  l'interface home
      StockListHome home = (StockListHome)
        PortableRemoteObject.narrow(ref, StockListHome.class);

      // Cration d'un objet StockList
      stockList = home.create();
    } catch(Exception e) {
      e.printStackTrace();
    }
    
    return stockList;
  }
  
  public void actionPerformed(ActionEvent ae) {

    if (ae.getSource() == _get) {
      try {
        int anlystNo = _analysts.getSelectedIndex();
        if (anlystNo < 0) {
          JOptionPane.showMessageDialog(this, "Aucun expert slectionn !");
          return;
        }
        Integer aId = _analystIds[anlystNo];
        if (_tickers.getSelectedIndex() < 0) {
          JOptionPane.showMessageDialog(this, "Aucun symbole slectionn !");
          return;
        }
        String tkr = (String) _tickers.getSelectedItem();
        if (_ratings.getSelectedIndex() < 0) {
          JOptionPane.showMessageDialog(this, "Aucune apprciation slectionn !");
          return;
        }
        String rtg = (String) _ratings.getSelectedItem();
        _stockList.addStockRating(tkr, aId, rtg);
        buildStockList();
        populateTickers();
      }
      catch (Exception e) {
        e.printStackTrace();
      }
    }
  }
  
  public static void main(String[] args) {
    StockClient stockClient = new StockClient();
  }
}