package client;

import facade.StockListFacade;
import vo.AnalystVo;
import vo.StockVo;

import java.util.*;

// general imports
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class StockClient extends JFrame 
  implements ActionListener { 
  private Integer[] _analystIds;
  private JButton _get = new JButton("Add Rating");
  private JPanel _stockPanel = new JPanel();
  private JComboBox _analysts = new JComboBox();
  private JComboBox _tickers = new JComboBox();
  private JComboBox _ratings = new JComboBox();
      
  public StockClient() {
    // Ajout du titre
    JLabel title = new JLabel("Stock Rating List");
    title.setHorizontalAlignment(JLabel.CENTER);
    getContentPane().add(title, BorderLayout.NORTH);
    
    JPanel activityPanel = new JPanel(new BorderLayout());
    try {
      // Ajout de la liste des actions
      buildStockList();
      JScrollPane scroller = new JScrollPane(_stockPanel);
      activityPanel.add(scroller, BorderLayout.CENTER);
      
      // Panneau des apprciation
      JPanel ratingPanel = new JPanel(new GridLayout(1, 3));
      // Ajout des analyste
      populateAnalysts();
      ratingPanel.add(_analysts);
      // Ajout des actions sans apprciation
      populateTickers();
      ratingPanel.add(_tickers);
      // Ajout des apprciations
      _ratings.addItem("A fuir !");
      _ratings.addItem("Pourrait tre pire !");
      _ratings.addItem("Moyen");
      _ratings.addItem("A tenter !");
      _ratings.addItem("Incontournable !");
      ratingPanel.add(_ratings);
      activityPanel.add(ratingPanel, BorderLayout.SOUTH);
      
      getContentPane().add(activityPanel, BorderLayout.CENTER);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
    
    // Ajout des boutons
    JPanel buttons = new JPanel(new GridLayout(1, 1));
    _get.addActionListener(this);
    buttons.add(_get);
    getContentPane().add(buttons, BorderLayout.SOUTH);
    
    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        System.exit(0);
      }
    });

    setSize(480, 250);
    setVisible(true);
  }
  
  private void buildStockList() throws Exception {
    ArrayList stoks = StockListFacade.getFacade().getStockRatings();
    _stockPanel.removeAll();
    _stockPanel.setLayout(new GridLayout(stoks.size(), 1));
    for (int i = 0; i < stoks.size(); i++) {
      StockVo stokInfo = (StockVo) stoks.get(i);
      Box stokLine = Box.createHorizontalBox();
      String stokDesc = stokInfo.getTickerSymbol() + " : " + 
        stokInfo.getName() + " ==> " +
        stokInfo.getAnalyst().getName() + " rates it: " + 
        stokInfo.getRating();
      stokLine.add(new JLabel(stokDesc));
      _stockPanel.add(stokLine);
    }
    _stockPanel.invalidate();
    _stockPanel.validate();
  }
  
  private void populateAnalysts() throws Exception {
    ArrayList anlysts = StockListFacade.getFacade().getAllAnalysts();
    _analystIds = new Integer[anlysts.size()];
    for (int i = 0; i < anlysts.size(); i++) {
      AnalystVo analystData = (AnalystVo) anlysts.get(i);
      _analystIds[i] = analystData.getAnalystId();
      _analysts.addItem(analystData.getName());
    }
  }
  
  private void populateTickers() throws Exception {
    _tickers.removeAllItems();
    ArrayList tkrs = StockListFacade.getFacade().getUnratedStocks();
    for (int i = 0; i < tkrs.size(); i++) {
      StockVo stockVo = (StockVo) tkrs.get(i);
      _tickers.addItem(stockVo.getTickerSymbol());
    }
    _tickers.invalidate();
    _tickers.validate();
  }
  
  public void actionPerformed(ActionEvent ae) {
    if (ae.getSource() == _get) {
      try {
        int anlystNo = _analysts.getSelectedIndex();
        if (anlystNo < 0) {
          JOptionPane.showMessageDialog(this, "No analyst selected!");
          return;
        }
        Integer aId = _analystIds[anlystNo];
        if (_tickers.getSelectedIndex() < 0) {
          JOptionPane.showMessageDialog(this, "No ticker selected!");
          return;
        }
        String tkr = (String) _tickers.getSelectedItem();
        if (_ratings.getSelectedIndex() < 0) {
          JOptionPane.showMessageDialog(this, "No rating selected!");
          return;
        }
        String rtg = (String) _ratings.getSelectedItem();
        StockVo stockVo = new StockVo(tkr, null, rtg);
        stockVo.setAnalyst(new AnalystVo(aId, null));
        StockListFacade.getFacade().addStockRating(stockVo);
        buildStockList();
        populateTickers();
      }
      catch (Exception e) {
        e.printStackTrace();
      }
    }
  }
  
  public static void main(String[] args) {
    StockClient stockClient = new StockClient();
  }
}