package facade;

import beans.StockList;
import beans.StockListHome;
import vo.AnalystVo;
import vo.StockVo;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

import java.util.*;

public class StockListFacade {
  // Rfrence au singleton faade
  private static StockListFacade stockListFacade;

  // Rfrence au bean StockList
  private StockList stockList;

  // Constructeur priv - Etablit la connexion avec le bean session
  private StockListFacade() throws StockListException {
    try {
      // Obtention d'un contexte JNDI
      InitialContext jndiContext = new InitialContext();

      // Obtention d'une rfrence  l'entre JNDI StockList
      Object ref  = jndiContext.lookup("ejb/beans.StockList");

      // Obtention d'une rfrence  l'interface home du bean
      StockListHome home = (StockListHome)
        PortableRemoteObject.narrow(ref, StockListHome.class);

      // Cration d'une instance de StockList
      stockList = home.create();
    } catch(Exception e) {
      throw new StockListException(e.getMessage());
    }
  }

  // Les mthodes applicatives. L'implmentation relle et les 
  // dtails de la communication avec le serveur ne sont pas
  // visibles par le client.

  public ArrayList getStockRatings() throws StockListException {
    try {
      ArrayList ratings = stockList.getStockRatings();
      return ratings;
    }
    catch (Exception re) {
      throw new StockListException(re.getMessage());
    }
  }

  public ArrayList getAllAnalysts() throws StockListException {
    try {
      ArrayList analysts = stockList.getAllAnalysts();
      return analysts;
    }
    catch (Exception re) {
      throw new StockListException(re.getMessage());
    }
  }

  public ArrayList getUnratedStocks() throws StockListException {
    try {
      ArrayList stocks = stockList.getUnratedStocks();
      return stocks;
    }
    catch (Exception re) {
      throw new StockListException(re.getMessage());
    }
  }

  public void addStockRating(StockVo stock)
    throws StockListException {
    try {
      stockList.addStockRating(stock);
    }
    catch (Exception re) {
      throw new StockListException(re.getMessage());
    }
  }

  public void addAnalyst(AnalystVo analyst)
    throws StockListException {
    try {
      stockList.addAnalyst(analyst);
    }
    catch (Exception re) {
      throw new StockListException(re.getMessage());
    }
  }

  public void addStock(StockVo stock) throws StockListException {
    try {
      stockList.addStock(stock);
    }
    catch (Exception re) {
      throw new StockListException(re.getMessage());
    }
  }

  public static StockListFacade getFacade()
    throws StockListException {
    if (stockListFacade == null) {
      stockListFacade = new StockListFacade();
    }

    return stockListFacade;
  }
}
