package web;

import javax.servlet.*;
import javax.servlet.http.*;
import facade.*;
import vo.*;

public class AddRating extends HttpServlet {
  public void doPost(HttpServletRequest request,
         HttpServletResponse response)
  {
    try {
      String analyst = request.getParameter("analysts");
      Integer id = new Integer(analyst);
      String ticker = request.getParameter("stocks");
      String rating = request.getParameter("ratings");
  
      StockVo stockVo = new StockVo(ticker, null, rating);
      stockVo.setAnalyst(new AnalystVo(id, null));
      StockListFacade facade = StockListFacade.getFacade();
      facade.addStockRating(stockVo);
  
      request.setAttribute("data", facade.getStockRatings());
      request.setAttribute("analysts", facade.getAllAnalysts());
      request.setAttribute("unrated", facade.getUnratedStocks());
  
      ServletContext context = getServletContext();
      RequestDispatcher dispatcher = 
      context.getNamedDispatcher("RatingsForm");
      dispatcher.forward(request, response);
    } catch (Exception e) {
        
    }
  }
}
