package web;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import facade.*;

public class StockListServlet extends HttpServlet {
  public void doPost(HttpServletRequest request,
         HttpServletResponse response)
  {
    doGet(request, response);
  }

  public void doGet(HttpServletRequest request,
        HttpServletResponse response)
  {
    try {
        ArrayList data = null;
        RequestDispatcher dispatcher;
        ServletContext context = getServletContext();
        StockListFacade facade = StockListFacade.getFacade();
        String name = request.getPathInfo();
        name = name.substring(1);
        System.out.println("name="+name);
        if ("AnalystForm".equals(name)) {
      data = facade.getAllAnalysts();
      request.setAttribute("data", data);
        } else if ("RatingsForm".equals(name)) {
      data = facade.getStockRatings();
      request.setAttribute("data", data);
      request.setAttribute("analysts", facade.getAllAnalysts());
      request.setAttribute("unrated", facade.getUnratedStocks());
        } else if ("AddRating".equals(name)) {
      // rien  faire, juste faire suivre la requte
        } else {
      name = "Error";
        }  
  
        dispatcher = context.getNamedDispatcher(name);
        if (dispatcher == null) {
      dispatcher = context.getNamedDispatcher("Error");
        }      
        dispatcher.forward(request, response);
    } catch (Exception e) {
        e.printStackTrace();
    }
  }
}
