package timer;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;

import java.text.*;
import java.util.*;

public class TimeItBean
  implements SessionBean, TimedObject {
  // Rfrence au contexte
  private SessionContext ctx;

  // Mthode applicative lanant le timer
  public void startTimer() {
    TimerService timerService = ctx.getTimerService();
    // Aprs cinq secondes, puis toutes les dix secondes
    Timer timer = timerService.createTimer(5000, 10000, "timer");
  }

  // Mthode EJB du timer - Le timer expire - Envoyer un message  la queue
  public void ejbTimeout(Timer timer) {
    QueueConnection queueConnection = null;
    try {
      InitialContext jndiContext = new InitialContext();
      // Rechercher une queueConnectionFactory
      QueueConnectionFactory queueConnectionFactory =
        (QueueConnectionFactory) jndiContext.lookup
        ("jms/QueueConnectionFactory");
      // Rechercher une queue (destination)
      Queue queue =
        (Queue) jndiContext.lookup("jms/LogWriterQueue");
      // Obtenir une connexion
      queueConnection =
        queueConnectionFactory.createQueueConnection();
      // Crer une session
      QueueSession queueSession =
        queueConnection.createQueueSession(false,
        Session.AUTO_ACKNOWLEDGE);
      // Crer un metteur pour la session,  destination de la queue
      QueueSender queueSender = queueSession.createSender(queue);
      // Crer un message
      TextMessage message = queueSession.createTextMessage();
      // Construire le message (une chane de caractres  afficher)
      SimpleDateFormat sdf =
        new SimpleDateFormat("yyyy.MM.dd 'a' HH:mm:ss.SSS");
      // Crer le texte du message
      message.setText
        ("entree log, date et heure : " + sdf.format(new Date()));
      // Envoyer le message
      queueSender.send(message);

    }
    catch (Exception e) {
      System.out.println("Exception dans le message: " + e.toString());
      e.printStackTrace();
    }
    finally {
      if (queueConnection != null) {
        try {
          queueConnection.close();
        }
        catch (Exception e) {}
      }
    }
  }

  // Mthodes standards EJB

  public void setSessionContext(SessionContext context) {
    ctx = context;
  }

  public void ejbCreate() {}
  public void ejbRemove() {}
  public void ejbActivate() {}
  public void ejbPassivate() {}
}
