package client;

import java.rmi.ServerException;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class CalculatorServiceClient extends JFrame
  implements ActionListener {

  private JButton _clear = new JButton("Effacer");
  private JButton _equals = new JButton("=");
  private JTextField _topNumber = new JTextField("0");
  private JTextField _bottomNumber = new JTextField("0");
  private JComboBox _operator = new JComboBox();
  private Call _call;

  public CalculatorServiceClient() {
    // Lire l'appel
    try {
      _call = this.getCall();
    }
    catch (Exception e) {
      e.printStackTrace();
    }

    // Ajouter le titre
    JLabel title = new JLabel("Calculatrice minimale");
    title.setHorizontalAlignment(JLabel.CENTER);
    getContentPane().add(title, BorderLayout.NORTH);

    // Ajouter le panneau de calcul
    JPanel calcPanel = new JPanel(new GridLayout(2, 2));
    calcPanel.add(new JLabel("Rsultat"));
    _topNumber.setEditable(false);
    calcPanel.add(_topNumber);
    _operator.addItem("+");
    _operator.addItem("-");
    calcPanel.add(_operator);
    calcPanel.add(_bottomNumber);
    getContentPane().add(calcPanel, BorderLayout.CENTER);

    // Ajouter les boutons
    JPanel buttonPanel = new JPanel(new GridLayout(2, 1));
    _equals.addActionListener(this);
    buttonPanel.add(_equals);
    _clear.addActionListener(this);
    buttonPanel.add(_clear);
    getContentPane().add(buttonPanel, BorderLayout.SOUTH);
    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        System.exit(0);
      }
    });

    setSize(300, 150);
    setVisible(true);
  }

  public void actionPerformed(ActionEvent ae) {
    // Si l'utilisateur a cliqu sur =, effectuer le calcul
    if (ae.getSource() == _equals) {
      runCalculator();
    }

    // Si l'utilisateur a cliqu sur Effacer, effacer le rsultat
    if (ae.getSource() == _clear) {
      clearCalculator();
    }
  }

  private Call getCall() throws Exception {
    ServiceFactory factory = ServiceFactory.newInstance();
    Service service =
      factory.createService(new QName("CalculatorService"));
    Call call = (Call) service.createCall();
    call.setPortTypeName(new QName("CalculatorServiceIF"));
    call.setTargetEndpointAddress(
      "http://localhost:8080/calc-jaxrpc/calc");
    call.setProperty(Call.SOAPACTION_USE_PROPERTY,
       new Boolean(true));
    call.setProperty(Call.SOAPACTION_URI_PROPERTY, "");
    call.setProperty("javax.xml.rpc.encodingstyle.namespace.uri",
        "http://schemas.xmlsoap.org/soap/encoding/");
    call.setProperty(Call.SESSION_MAINTAIN_PROPERTY,
       new Boolean(true));
    return call;
  }

  private void runCalculator() {
    try {
      // Obtenir la valeur courante
      int operVal = 0;
      String textVal = _bottomNumber.getText();
      if (textVal != null) {
        try {
          operVal = Integer.parseInt(textVal);
        }
        catch (NumberFormatException nfe) { }
      }

      // Obtenir l'oprateur
      String oper = (String) _operator.getSelectedItem();

      // Appeler le service pour calculer la nouvelle valeur
      Object[] calcParms =
        new Object[] { oper, new Integer(operVal) };
      _call.removeAllParameters();
      _call.setReturnType(null);
      _call.setOperationName(new QName("urn:calculatorService",
                                       "calculate"));
      _call.addParameter("String_1",
        new QName("http://www.w3.org/2001/XMLSchema", "string"),
        ParameterMode.IN);
      _call.addParameter("int_2",
          new QName("http://www.w3.org/2001/XMLSchema", "int"),
                    ParameterMode.IN);
      Object ret = _call.invoke(calcParms);

      // invoke the service to display the new value
      Object[] getParms = new Object[0];
      _call.removeAllParameters();
      _call.setOperationName(new QName("urn:calculatorService",
                                        "getValue"));
      _call.setReturnType(
        new QName("http://www.w3.org/2001/XMLSchema", "int"));
      Integer getRet = (Integer) _call.invoke(getParms);
      _topNumber.setText(getRet.toString());
    }
    catch (ServerException se) {
      JOptionPane.showMessageDialog(this, se.getMessage());
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void clearCalculator() {
    try {
      // Appeler le service pour effacer le rsultat
      Object[] parms = new Object[0];
      _call.removeAllParameters();
      _call.setReturnType(null);
      _call.setOperationName(new QName("urn:calculatorService",
                                        "clearIt"));
      Object ret = _call.invoke(parms);
      _topNumber.setText("0");
      _bottomNumber.setText("0");
      _operator.setSelectedIndex(0);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  public static void main(String[] args) {
    CalculatorServiceClient calcClient =
      new CalculatorServiceClient();
  }
}