package webservices;

import javax.servlet.http.HttpSession;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.server.ServletEndpointContext;

public class CalculatorServiceImpl
  implements CalculatorServiceIF, ServiceLifecycle {

  private ServletEndpointContext _endpointContext = null;

  // Mthodes du cycle de vie du service
  public void init(Object context) throws ServiceException {
    _endpointContext = (ServletEndpointContext) context;
  }

  public void destroy() { System.out.println("Destruction"); }

  // Implmentation des mthodes applicatives
  public void clearIt() {
    HttpSession session = _endpointContext.getHttpSession();
    session.setAttribute("balance", new Integer(0));
  }

  public void calculate(String operation, int value)
    throws Exception {
    // Lire le rsultat courant
    HttpSession session = _endpointContext.getHttpSession();
    Integer val = pluckValue();
    int bal = val.intValue();

    // Si "+", additionner
    if (operation.equals("+")) {
      bal = bal + value;
      session.setAttribute("balance", new Integer(bal));
      return;
    }

    // Si "-", soustraire
    if (operation.equals("-")) {
      bal = bal - value;
      if (bal < 0) {
        throw new Exception("Rsultat ngatif");
      }
      session.setAttribute("balance", new Integer(bal));
      return;
    }

    // Si ni "+" ni "-", l'opration n'est pas valide
    throw new Exception("Opration invalide");
  }

  public int getValue() {
    return pluckValue().intValue();
  }

  private Integer pluckValue() {
    HttpSession session = _endpointContext.getHttpSession();
    Integer val = (Integer) session.getAttribute("balance");
    if (val == null) {
      val = new Integer(0);
    }
    return val;
  }
}
