package com.yaps.petstore.delegate;

import com.yaps.petstore.locator.ServiceLocator;
import com.yaps.petstore.entity.Address;
import com.yaps.petstore.entity.customer.Customer;
import com.yaps.petstore.stateless.customer.CustomerRemote;

import java.util.List;

/**
 * This class follows the Delegate design pattern. It's a one to one method
 * with the CustomerBean class. Each method delegates the call to the
 * CustomerBean class
 */
public final class CustomerDelegate {

    // ======================================
    // =           Business methods         =
    // ======================================

    public static Customer createCustomer(Customer customer, Address address) {
        return getCustomerRemote().createCustomer(customer, address);
    }

    public static Customer findCustomer(Long customerId) {
        return getCustomerRemote().findCustomer(customerId);
    }

    public static void deleteCustomer(Customer customer) {
        getCustomerRemote().deleteCustomer(customer);
    }

    public static Customer updateCustomer(Customer customer, Address address) {
        return getCustomerRemote().updateCustomer(customer, address);
    }

    public static List<Customer> findCustomers() {
        return getCustomerRemote().findCustomers();
    }

    // ======================================
    // =            Private methods         =
    // ======================================
    private static CustomerRemote getCustomerRemote() {
        CustomerRemote customerRemote;
        customerRemote = (CustomerRemote) ServiceLocator.getInstance().getRemoteInterface("ejb/stateless/Customer");
        return customerRemote;
    }
}
