package com.yaps.petstore.entity.catalog;

import com.yaps.petstore.exception.ValidationException;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Collection;

/**
 * Cette classe reprsente un Article du catalogue de la socit YAPS.
 * Le catalogue se divise en categories, en produits puis en articles.
 *
 * @author Antonio Goncalves
 * @see com.yaps.petstore.entity.catalog.Category
 * @see Item
 */

@Entity
@Table(name = "t_item")
public class Item implements Serializable {

    // ======================================
    // =             Attributs              =
    // ======================================
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;
    @Column(nullable = false, length = 30)
    private String name;
    @Column(name = "unit_cost", nullable = false)
    private Float unitCost;
    @Column(name = "image_path")
    private String imagePath;
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "product_fk", nullable = false)
    private Product product;

    // ======================================
    // =             Constantes             =
    // ======================================

    // ======================================
    // =            Constructeurs           =
    // ======================================
    public Item() {
    }

    public Item(String name, Float unitCost) {
        this.name = name;
        this.unitCost = unitCost;
    }

    // ======================================
    // =     Methodes Lifecycle Callback    =
    // ======================================
    @PrePersist
    @PreUpdate
    private void validateData() {
        if (name == null || "".equals(name))
            throw new ValidationException("Invalid name");
    }

    // ======================================
    // =          Methodes publiques        =
    // ======================================

    // ======================================
    // =          Methodes Protges        =
    // ======================================

    // ======================================
    // =             Accesseurs             =
    // ======================================

    public Long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Float getUnitCost() {
        return unitCost;
    }

    public void setUnitCost(Float unitCost) {
        this.unitCost = unitCost;
    }

    public String getImagePath() {
        return imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public Product getProduct() {
        return product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    // ======================================
    // =           Methodes Prives         =
    // ======================================

    // ======================================
    // =   Methodes hash, equals, toString  =
    // ======================================
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Item item = (Item) o;

        if (!id.equals(item.id)) return false;
        if (imagePath != null ? !imagePath.equals(item.imagePath) : item.imagePath != null) return false;
        if (!name.equals(item.name)) return false;
        if (!unitCost.equals(item.unitCost)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result;
        result = id.hashCode();
        result = 31 * result + name.hashCode();
        result = 31 * result + unitCost.hashCode();
        result = 31 * result + (imagePath != null ? imagePath.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append("Item");
        sb.append("{id=").append(id);
        sb.append(", name='").append(name).append('\'');
        sb.append(", unitCost=").append(unitCost);
        sb.append(", imagePath='").append(imagePath).append('\'');
        sb.append(", product=").append(product);
        sb.append('}');
        return sb.toString();
    }
}