package com.yaps.petstore.entity.catalog;

import com.yaps.petstore.exception.ValidationException;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;

/**
 * Cette classe reprsente un Produit du catalogue de la socit YAPS.
 * Le catalogue se divise en categories, en produits puis en articles.
 *
 * @author Antonio Goncalves
 * @see Category
 * @see Item
 */

@Entity
@Table(name = "t_product")
public class Product implements Serializable {

    // ======================================
    // =             Attributs              =
    // ======================================
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;
    @Column(nullable = false, length = 30)
    private String name;
    @Column(nullable = false)
    private String description;
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "category_fk", nullable = false)
    private Category category;
    @OneToMany(mappedBy = "product",  cascade = CascadeType.REMOVE, fetch = FetchType.LAZY)
    @OrderBy("name ASC")
    private List<Item> items;

    // ======================================
    // =             Constantes             =
    // ======================================

    // ======================================
    // =            Constructeurs           =
    // ======================================
    public Product() {
    }

    public Product(String name, String description) {
        this.name = name;
        this.description = description;
    }

    // ======================================
    // =          Methodes publiques        =
    // ======================================
    // ======================================
    // =     Methodes Lifecycle Callback    =
    // ======================================
    @PrePersist
    @PreUpdate
    private void validateData() {
        if (name == null || "".equals(name))
            throw new ValidationException("Invalid name");
        if (description == null || "".equals(description))
            throw new ValidationException("Invalid description");
    }

    // ======================================
    // =          Methodes Protges        =
    // ======================================

    // ======================================
    // =             Accesseurs             =
    // ======================================

    public Long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Category getCategory() {
        return category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public List<Item> getItems() {
        return items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }
    // ======================================
    // =           Methodes Prives         =
    // ======================================

    // ======================================
    // =   Methodes hash, equals, toString  =
    // ======================================
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Product product = (Product) o;

        if (!description.equals(product.description)) return false;
        if (!id.equals(product.id)) return false;
        if (!name.equals(product.name)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result;
        result = id.hashCode();
        result = 31 * result + name.hashCode();
        result = 31 * result + description.hashCode();
        return result;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append("Product");
        sb.append("{id=").append(id);
        sb.append(", name='").append(name).append('\'');
        sb.append(", description='").append(description).append('\'');
        sb.append(", category=").append(category);
        sb.append(", items=").append(items == null ? 0 : items.size());
        sb.append('}');
        return sb.toString();
    }
}