package com.yaps.petstore.stateless.catalog;

import com.yaps.petstore.entity.catalog.Category;
import com.yaps.petstore.entity.catalog.Item;
import com.yaps.petstore.entity.catalog.Product;

import javax.ejb.Remote;
import java.util.List;

/**
 * @author Antonio Goncalves
 */
@Remote
public interface CatalogRemote {

    // ======================================
    // =          Methodes publiques        = 
    // ======================================
    Category createCategory(Category category);

    Category findCategory(Long categoryId);

    void deleteCategory(Category category);

    Category updateCategory(Category category);

    List<Category> findCategories();

    Product createProduct(Product product, Category category);

    Product findProduct(Long productId);

    void deleteProduct(Product product);

    Product updateProduct(Product product, Category category);

    List<Product> findProducts();

    Item createItem(Item item, Product product);

    Item findItem(Long itemId);

    void deleteItem(Item item);

    Item updateItem(Item item, Product product);

    List<Item> findItems();
}