package com.yaps.petstore.entity.customer;

import static com.yaps.petstore.TestHelper.*;

import com.yaps.petstore.util.Constants;
import org.junit.AfterClass;
import static org.junit.Assert.*;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import javax.persistence.*;
import java.util.List;

/**
 * Test unitaire de la classe Customer
 *
 * @author Antonio Goncalves
 * @see com.yaps.petstore.entity.Address
 */
public class CustomerTest {

    // ======================================
    // =             Attributs              =
    // ======================================
    private static EntityManagerFactory emf;
    private static EntityManager em;
    private static EntityTransaction tx;

    // ======================================
    // =              Fixture               =
    // ======================================

    @BeforeClass
    public static void initEntityManager() {
        emf = Persistence.createEntityManagerFactory(Constants.PERSISTENCE_UNIT_NAME);
        em = emf.createEntityManager();
    }

    @AfterClass
    public static void closeEntityManager() {
        em.close();
        emf.close();
    }

    @Before
    public void initEntityTransaction() {
        tx = em.getTransaction();
    }

    // ======================================
    // =              Test cases            =
    // ======================================

    /**
     * Ce test s'assure que la cration, lecture, mise  jour et suppression d'un objet
     * en base de donnes fonctionne.
     */
    @Test
    public void crud() throws Exception {
        Long random = getRandom();
        Long updateRandom = getRandom();
        Customer customer = new Customer();

        // Rcupre tous les objets prsent en base de donnes
        int firstFindAll = findAll();

        // Cre un objet et le persiste en base de donne
        customer = getMockCustomerValues(customer, random);
        tx.begin();
        em.persist(customer);
        tx.commit();
        Long id = customer.getId();

        // On s'assure que l'objet a bien t cr et que les valeurs sont bien les bonnes
        customer = em.find(Customer.class, id);
        assertNotNull("Object should exist", customer);
        checkMockCustomerValues(customer, random);

        // Mise  jour de l'objet avec de nouvelles valeurs
        customer = getMockCustomerValues(customer, updateRandom);
        tx.begin();
        em.merge(customer);
        tx.commit();

        // On s'assure que l'objet a bien t mis  jour et que les valeurs sont bien les bonnes
        customer = em.find(Customer.class, id);
        assertNotNull("Object should exist", customer);
        checkMockCustomerValues(customer, updateRandom);

        // On rcupre tous les objets prsent en base de donnes...
        int secondFindAll = findAll();

        // ...et on s'assure qu'il y a une occurence supplmentaire
        if (firstFindAll + 1 != secondFindAll) fail("The collection size should have increased by 1");

        // On supprime l'objet de la base de donnes
        tx.begin();
        em.remove(customer);
        tx.commit();

        // On s'assure que l'objet a bien t supprim
        customer = em.find(Customer.class, id);
        assertNull("Object should not exist", customer);

        // On rcupre tous les objets prsent en base de donnes...
         int thirdFindAll = findAll();

        // ...et on s'assure qu'il y ait le mme nombre initial d'occurences
        if (firstFindAll != thirdFindAll) fail("The collection size should have be the same as original");
    }

    // ======================================
    // =           Methodes Prives         =
    // ======================================
    private int findAll() {
        Query query = em.createQuery("SELECT p FROM Customer p");
        List result = query.getResultList();
        if (result == null)
            return 0;
        else
            return result.size();
    }
}