package com.yaps.petstore.jsf;

import com.yaps.petstore.entity.Address;
import com.yaps.petstore.entity.catalog.Item;
import com.yaps.petstore.entity.customer.Customer;
import com.yaps.petstore.entity.order.CreditCard;
import com.yaps.petstore.entity.order.Order;
import com.yaps.petstore.stateful.ShoppingCartLocal;
import com.yaps.petstore.dto.CartItem;
import com.yaps.petstore.stateless.catalog.CatalogLocal;
import com.yaps.petstore.stateless.order.OrderLocal;
import com.yaps.petstore.exception.CreditCardException;
import com.yaps.barkbank.validator.ValidationService;
import com.yaps.barkbank.validator.Validation;

import javax.ejb.EJB;
import javax.xml.ws.WebServiceRef;
import java.util.List;

/**
 * @author Antonio Goncalves
 */
public class ShoppingCartController extends Controller {

    // ======================================
    // =             Attributs              = 
    // ======================================
    @EJB
    private ShoppingCartLocal shoppingCartBean;
    @EJB
    private CatalogLocal catalogBean;
    @EJB
    private OrderLocal orderBean;
//    @WebServiceRef
    @WebServiceRef(wsdlLocation = "http://localhost:8080/barkbank/ValidationService?WSDL") //TODO la valeur par dfaut suffit, on peut supprimer cette ligne
    private ValidationService validationService;

    private final String cname = this.getClass().getName();

    private CreditCard creditCard = new CreditCard();
    // Customer et Address sont initialiss par le faces-config.xml
    private Customer customer;
    private Address deliveryAddress;
    private Order order;

    // ======================================
    // =          Methodes publiques        =
    // ======================================

    public String addItemToCart() {
        final String mname = "addItemToCart";
        logger.entering(cname, mname);

        String navigateTo = null;

        try {
            Item item = catalogBean.findItem(getParamId("itemId"));
            shoppingCartBean.addItem(item);
            navigateTo = "item.added";
        } catch (Exception e) {
            addMessage(cname, mname, e);
        }

        logger.exiting(cname, mname, navigateTo);
        return navigateTo;
    }

    public String removeItemFromCart() {
        final String mname = "removeItemFromCart";
        logger.entering(cname, mname);

        String navigateTo = null;

        try {
            Item item = catalogBean.findItem(getParamId("itemId"));
            shoppingCartBean.removeItem(item);
        } catch (Exception e) {
            addMessage(cname, mname, e);
        }

        logger.exiting(cname, mname, navigateTo);
        return navigateTo;
    }

    public String updateQuantity() {
        final String mname = "updateQuantity";
        logger.entering(cname, mname);

        String navigateTo = null;

        logger.exiting(cname, mname, navigateTo);
        return navigateTo;
    }

    public String checkout() {
        final String mname = "checkout";
        logger.entering(cname, mname);

        String navigateTo = "cart.checked.out";

        logger.exiting(cname, mname, navigateTo);
        return navigateTo;
    }

    public String confirmOrder() {
        final String mname = "confirmOrder";
        logger.entering(cname, mname);

        String navigateTo = null;

        try {
            // Calls the web service to validate the credit card
            validateCreditCard(creditCard);
            order = orderBean.createOrder(customer, deliveryAddress, creditCard, shoppingCartBean.getCartItems());
            shoppingCartBean.empty();
            navigateTo = "order.confirmed";
        } catch (Exception e) {
            addMessage(cname, mname, e);
        }

        logger.exiting(cname, mname, navigateTo);
        return navigateTo;
    }

    public Float getTotal() {
        return shoppingCartBean.getTotal();
    }

    public List<CartItem> getCartItems() {
        return shoppingCartBean.getCartItems();
    }

    // ======================================
    // =             Accesseurs             =
    // ======================================

    public Customer getCustomer() {
        return customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public Address getDeliveryAddress() {
        return deliveryAddress;
    }

    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public CreditCard getCreditCard() {
        return creditCard;
    }

    public void setCreditCard(CreditCard creditCard) {
        this.creditCard = creditCard;
    }

    public Order getOrder() {
        return order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    // ======================================
    // =           Methodes Prives         =
    // ======================================

    private void validateCreditCard(CreditCard creditCard) {
        String statusCard;

        Validation validation = validationService.getValidationPort();
        statusCard = validation.validateCard(creditCard.getCreditCardNumber(),
                creditCard.getCreditCardType(),
                creditCard.getCreditCardExpDate());
        logger.info("Validation Service has been called. isCardValid=" + statusCard);

        if (!"OK".equals(statusCard))
            throw new CreditCardException("Credit Card is invalid : " + statusCard);

    }
}