package com.yaps.barkbank.validator;

import com.yaps.barkbank.validator.Validation;
import org.junit.Test;

import static org.junit.Assert.assertEquals;

/**
 * @author Antonio Goncalves
 */
public class ValidationServiceTest {

    // ======================================
    // =              Test cases            =
    // ======================================

    /**
     * This test ensures that the validation method works
     */

    @Test
    public void shouldValidateSeveralCards() throws Exception {
        Validation validator = new Validation();
        assertEquals(Validation.CARD_OK, validator.validateCreditCard("1234", "Visa", "01/19"));
        assertEquals(Validation.INVALID_VISA, validator.validateCreditCard("1231", "Visa", "01/18"));
        assertEquals(Validation.INVALID_YEAR, validator.validateCreditCard("1234", "Visa", "01/08"));
        assertEquals(Validation.INVALID_MONTH, validator.validateCreditCard("1234", "Visa", "07/10"));
    }
}