package com.yaps.petex.transport;

/**
 * @author Antonio Goncalves
 */
public class DeliveryPlace {

    // ======================================
    // =             Attributs              = 
    // ======================================
    private String contact;
    private String street;
    private String city;
    private String state;
    private String zipcode;
    private String country;

    // ======================================
    // =             Constantes             =
    // ======================================

    // ======================================
    // =            Constructeurs           =
    // ======================================

    public DeliveryPlace() {
    }

    public DeliveryPlace(String contact, String street, String city, String state, String zipcode, String country) {
        this.contact = contact;
        this.street = street;
        this.city = city;
        this.state = state;
        this.zipcode = zipcode;
        this.country = country;
    }

    // ======================================
    // =          Methodes publiques        = 
    // ======================================

    // ======================================
    // =          Methodes Protges        = 
    // ======================================

    // ======================================
    // =             Accesseurs             = 
    // ======================================

    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getStreet() {
        return street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getZipcode() {
        return zipcode;
    }

    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    // ======================================
    // =           Methodes Prives         =
    // ======================================

    // ======================================
    // =   Methodes hash, equals, toString  =
    // ======================================

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append("DeliveryPlace");
        sb.append("{contact='").append(contact).append('\'');
        sb.append(", street='").append(street).append('\'');
        sb.append(", city='").append(city).append('\'');
        sb.append(", state='").append(state).append('\'');
        sb.append(", zipcode='").append(zipcode).append('\'');
        sb.append(", country='").append(country).append('\'');
        sb.append('}');
        return sb.toString();
    }
}