package com.yaps.petstore.delegate;

import com.yaps.petstore.locator.ServiceLocator;
import com.yaps.petstore.entity.order.Order;
import com.yaps.petstore.stateless.order.OrderRemote;

import java.util.List;

/**
 * This class follows the Delegate design pattern. It's a one to one method
 * with the OrderBean class. Each method delegates the call to the
 * OrderBean class
 */
public final class OrderDelegate {

    // ======================================
    // =           Business methods         =
    // ======================================

    public static Order findOrder(Long orderId) {
        return getOrderRemote().findOrder(orderId);
    }

    public static void deleteOrder(Order order) {
        getOrderRemote().deleteOrder(order);
    }

    public static List<Order> findOrders() {
        return getOrderRemote().findOrders();
    }

    // ======================================
    // =            Private methods         =
    // ======================================
    private static OrderRemote getOrderRemote() {
        OrderRemote orderRemote;
        orderRemote = (OrderRemote) ServiceLocator.getInstance().getRemoteInterface("ejb/stateless/Order");
        return orderRemote;
    }
}
