package com.yaps.petstore.dto;

import com.yaps.petstore.entity.catalog.Item;

/**
 * @author Antonio Goncalves
 */
public class CartItem {

    // ======================================
    // =             Attributs              = 
    // ======================================
    private Item item;
    private Integer quantity;

    // ======================================
    // =            Constructeurs           =
    // ======================================
    public CartItem(Item item, Integer quantity) {
        this.item = item;
        this.quantity = quantity;
    }

    // ======================================
    // =          Methodes publiques        =
    // ======================================

    public Float getSubTotal() {
        return item.getUnitCost() * quantity;
    }

    // ======================================
    // =             Accesseurs             =
    // ======================================
    public Item getItem() {
        return item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }
}