CREATE TABLE t_order_order_line (order_fk BIGINT, order_line_fk BIGINT);
CREATE TABLE t_item (ID BIGINT NOT NULL, unit_cost FLOAT NOT NULL, image_path VARCHAR(255), NAME VARCHAR(30) NOT NULL, product_fk BIGINT NOT NULL, PRIMARY KEY (ID));
CREATE TABLE t_category (ID BIGINT NOT NULL, NAME VARCHAR(30) NOT NULL, DESCRIPTION VARCHAR(255) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE t_order (ID BIGINT NOT NULL, order_date DATE, credit_card_type VARCHAR(255), credit_card_number VARCHAR(30), credit_card_expiry_date VARCHAR(5), customer_fk BIGINT NOT NULL, address_fk BIGINT NOT NULL, PRIMARY KEY (ID));
CREATE TABLE t_order_line (ID BIGINT NOT NULL, QUANTITY INTEGER NOT NULL, item_fk BIGINT NOT NULL, PRIMARY KEY (ID));
CREATE TABLE t_address (ID BIGINT NOT NULL, CITY VARCHAR(100) NOT NULL, STATE VARCHAR(255), STREET2 VARCHAR(255), zip_code VARCHAR(10) NOT NULL, STREET1 VARCHAR(255) NOT NULL, COUNTRY VARCHAR(50) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE t_product (ID BIGINT NOT NULL, DESCRIPTION VARCHAR(255) NOT NULL, NAME VARCHAR(30) NOT NULL, category_fk BIGINT NOT NULL, PRIMARY KEY (ID));
CREATE TABLE t_customer (ID BIGINT NOT NULL, LASTNAME VARCHAR(30) NOT NULL, TELEPHONE VARCHAR(255), PASSWORD VARCHAR(8) NOT NULL, EMAIL VARCHAR(255), LOGIN VARCHAR(8) UNIQUE NOT NULL, date_of_birth DATE, FIRSTNAME VARCHAR(30) NOT NULL, address_fk BIGINT, PRIMARY KEY (ID));
ALTER TABLE t_order_order_line ADD CONSTRAINT trdrorderlinerdrfk FOREIGN KEY (order_fk) REFERENCES t_order (ID);
ALTER TABLE t_order_order_line ADD CONSTRAINT trdrrdrlinerdrlnfk FOREIGN KEY (order_line_fk) REFERENCES t_order_line (ID);
ALTER TABLE t_item ADD CONSTRAINT t_item_product_fk FOREIGN KEY (product_fk) REFERENCES t_product (ID);
ALTER TABLE t_order ADD CONSTRAINT t_ordercustomer_fk FOREIGN KEY (customer_fk) REFERENCES t_customer (ID);
ALTER TABLE t_order ADD CONSTRAINT t_order_address_fk FOREIGN KEY (address_fk) REFERENCES t_address (ID);
ALTER TABLE t_order_line ADD CONSTRAINT torder_lineitem_fk FOREIGN KEY (item_fk) REFERENCES t_item (ID);
ALTER TABLE t_product ADD CONSTRAINT tproductcategoryfk FOREIGN KEY (category_fk) REFERENCES t_category (ID);
ALTER TABLE t_customer ADD CONSTRAINT tcustomeraddressfk FOREIGN KEY (address_fk) REFERENCES t_address (ID);
CREATE TABLE SEQUENCE (SEQ_NAME VARCHAR(50) NOT NULL, SEQ_COUNT DECIMAL, PRIMARY KEY (SEQ_NAME));
INSERT INTO SEQUENCE(SEQ_NAME, SEQ_COUNT) values ('SEQ_GEN', 0);
