VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Order"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"34F5AF2C024D"
Option Explicit

' $Version: $
' $Auteur: Davids $
' $Date: 15/4/98 5:17p $

Public Function Create(ByVal GarageName As String, ByVal GarageAddress As String, _
                       ByVal GarageTown As String, ByVal GarageState As String, _
                       ByVal GarageZipCode As String, ByVal SalesPerson As String, _
                       PricePaid As Currency, ByVal CustomerName As String, _
                       ByVal CustomerAddress As String, ByVal CustomerTown As String, _
                       ByVal CustomerState As String, ByVal CustomerZipCode As String, _
                       ByVal CustomerPhone As String, _
                       ByVal CarID As Long, ByVal ColorID As Long, _
                       ByRef OrderNumber As Variant, ByRef DeliveryDate As Variant, _
                       ByRef ReturnValue As Variant, _
                       Optional HOConnectionString As Variant, _
                       Optional SRConnectionString As Variant) As Boolean

    On Error GoTo Create_Error

    Dim objContext      As ObjectContext        ' Objet contexte MTS 
    Dim objHOOrder      As HeadOfficeOrder      ' commande sige
    Dim objSROrder      As ShowroomOrder        ' commande concessionnaire
    Dim strSROrderID    As String               ' no concessionnaire
    Dim strRV           As String               ' valeur de retour

    ' obtenir l'objet contexte MTS
    Set objContext = GetObjectContext


    ' instancier les objets commandes
    Set objHOOrder = objContext.CreateInstance("WCCHOOrder.HeadOfficeOrder")
    Set objSROrder = objContext.CreateInstance("WCCSROrder.ShowroomOrder")

    ' cration de la commande concessionnaire
    If IsMissing(SRConnectionString) Then
        SRConnectionString = RegistryRestore("HeadOffice", "Not Set")
    End If
    objSROrder.Create CarID, ColorID, SalesPerson, PricePaid, _
                      CustomerName, CustomerAddress, CustomerTown, _
                      CustomerState, CustomerZipCode, CustomerPhone, _
                      strSROrderID, SRConnectionString

    ' cration de la commande sige
    If IsMissing(HOConnectionString) Then
        HOConnectionString = RegistryRestore("HeadOffice", "Not Set")
    End If
    objHOOrder.Create GarageName, GarageAddress, GarageTown, _
                      GarageState, GarageZipCode, strSROrderID, _
                      SalesPerson, CustomerName, CustomerAddress, _
                      CustomerTown, CustomerState, CustomerZipCode, _
                      CustomerPhone, CarID, ColorID, _
                      OrderNumber, DeliveryDate, _
                      strRV, _
                      HOConnectionString

    ' si nous avons lev notre propre erreur (stock insuffisant) nous
    ' renvoyons seulement un code de retour et sortons- le composant avorte la transaction
    If strRV = 50001 Then
        ReturnValue = 50001
    Else
        ' mise  jour des dtails de la commande sige
        objSROrder.UpdateHODetails strSROrderID, OrderNumber, DeliveryDate, SRConnectionString

        ' fin, on demande le commit  MTS
        objContext.SetComplete

        ReturnValue = -1
    End If

Create_Exit:
    ' nettoyage et sortie
    If Not objContext Is Nothing Then
        Set objContext = Nothing
    End If
    If Not objHOOrder Is Nothing Then
        Set objHOOrder = Nothing
    End If
    If Not objSROrder Is Nothing Then
        Set objSROrder = Nothing
    End If
    Exit Function

Create_Error:
    ' demander  MTS to d'avorter la transaction
    objContext.SetAbort

    Err.Raise Err.Number, "WCCOrder.Create", Err.Description
    Resume Create_Exit
    
End Function

