VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "StringBag"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

'-----------------------------------------------------------------------
' Objet:        Ce "sac  chane" permet simplement d'ajouter des lments
'               dans une collection et de srialiser la collection dans
'               une chane que l'on peut ensuite placer dans le corps (Body)
'               d'un message.
' Classes utilises: aucune
' Rfrences:   aucune
'-----------------------------------------------------------------------

' Proprits et cls
Private mcolProperties      As Collection       ' proprits
Private mcolKeys            As Collection       ' cls

' la chane qui utilise comme sparateur
Private mstrSeparator       As String

Public Sub Add(ByVal strKey As String, ByVal strValue As String)
Attribute Add.VB_Description = "Adds an item to the string bag"
'
' Objet:      Ajout d'un lment dans la chane
' Arguments:  strKey      cl de l'lment
'             strValue    valeur de l'lment
' Retours:    aucun

    mcolProperties.Add strValue, strKey
    mcolKeys.Add strKey, strKey

End Sub

Public Function Item(ByVal strKey As String) As String
Attribute Item.VB_Description = "Get an item from the string bag"
Attribute Item.VB_UserMemId = 0
'
' Objet:        rcupration d'un lment  partir de la chane
' Arguments:    strKey      cl de l'llment  rcuprer
' Retours:      la valeur de l'lment rcupr

    Item = mcolProperties(strKey)

End Function

Private Sub Class_Initialize()
'
' Purpose:      initialisation du "sac  chane"
' Arguments:    aucun
' Retours:      aucun

    mstrSeparator = Chr$(0)
    Set mcolProperties = New Collection
    Set mcolKeys = New Collection

End Sub

Public Function Serialize() As String
Attribute Serialize.VB_Description = "Serialse the string bag into a string"
'
' Objet:      srialisation du contenu de la collection dans une seule chane
' Arguments:    aucun
' Retours:      la chane srialise
' Notes:        dans la chane les valeurs se succdent toujours dans le mme ordre : cl, sparateur, valeur

    Dim strOutput       As String       ' chane de sortie srialise
    Dim vntKey          As Variant      ' cl retourne provenant de la collection
    Dim strKey          As String       ' cl en version String
    Dim strItem         As String       ' valeur retourne pour la cl

    ' on fait une itration sur toute la collection contenant les cls
    For Each vntKey In mcolKeys
        strKey = CStr(vntKey)
        strItem = mcolProperties(strKey)
    
        ' on ajoute la paire cl-valeur  la chane de sortie
        strOutput = strOutput & strKey & mstrSeparator & strItem & mstrSeparator
    Next
    
    Serialize = strOutput

End Function

Public Sub DeSerialize(ByVal strString As String)
Attribute DeSerialize.VB_Description = "Deserialize the string bag into a sring"
'
' Objet:        extraction des paires cl-valeur se trouvant dans une chane srialise
' Arguments:    strString       chane srialise
' Retours:      aucun
' Notes:        dans la chane srialise les valeurs se succdent toujours dans l'ordre : cl, sparateur, valeur

    Dim strKey          As String       ' cl
    Dim strValue        As String       ' valeur
    Dim lngSeperator    As Long         ' position du sparateur

    ' la boucle s'excute tant que la chane n'est pas vide
    While (strString <> "")
        
        ' on localise un sparateur
        lngSeperator = InStr(strString, mstrSeparator)
        
        ' on sort s'il n'y a pas de sparateur dans la chane
        If (lngSeperator = 0) Then
            Err.Raise vbError + 1, "StringBag.DeSerialise", "Missing separator in string"
            Exit Sub
        End If

        ' on extrait la portion de chaine qui correspond  la cl
        strKey = Left(strString, lngSeperator - 1)
        strString = Mid(strString, lngSeperator + 1)

        ' le sparateur suivant prcde la chane qui correspond  la valeur
        lngSeperator = InStr(strString, mstrSeparator)
        
        ' on sort s'il n'y a pas de sparateur
        If (lngSeperator = 0) Then
            Err.Raise vbError + 1, "StringBag.DeSerialise", "Missing separator in string"
            Exit Sub
        End If
        
        ' on extrait la portion de chane correspondant  la valeur
        strValue = Left(strString, lngSeperator - 1)
        strString = Mid(strString, lngSeperator + 1)
        
        ' on peut maintenant ajouter  la collection une paire cl-valeur
        Add strKey, strValue
    Wend

End Sub

Private Sub Class_Terminate()
'
' Purpose:      nettoyage du "sac  chane"
' Arguments:    aucun
' Returns:      aucun

    Set mcolProperties = Nothing
    Set mcolKeys = Nothing

End Sub
