VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Begin VB.Form frmNewOrders 
   Caption         =   "Nouvelles commandes"
   ClientHeight    =   6105
   ClientLeft      =   1215
   ClientTop       =   1545
   ClientWidth     =   8775
   LinkTopic       =   "Form1"
   ScaleHeight     =   6105
   ScaleWidth      =   8775
   Begin MSFlexGridLib.MSFlexGrid grdOrders 
      Height          =   3735
      Left            =   120
      TabIndex        =   3
      Top             =   120
      Width           =   8535
      _ExtentX        =   15055
      _ExtentY        =   6588
      _Version        =   393216
      Cols            =   6
      FixedCols       =   0
      GridLines       =   0
      SelectionMode   =   1
      AllowUserResizing=   1
   End
   Begin VB.CommandButton cmdUpdate 
      Caption         =   "&Mettre  jour"
      Enabled         =   0   'False
      Height          =   375
      Left            =   4680
      TabIndex        =   2
      Top             =   5520
      Width           =   1455
   End
   Begin VB.TextBox txtDeliveryDate 
      Height          =   285
      Left            =   3000
      TabIndex        =   1
      Top             =   5520
      Width           =   1455
   End
   Begin VB.Label lblDeliveryDate 
      Caption         =   "Date de livraison"
      Height          =   255
      Left            =   1560
      TabIndex        =   0
      Top             =   5520
      Width           =   1215
   End
End
Attribute VB_Name = "frmNewOrders"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' $Revision: 2 $
' $Author: Davids $
' $Date: 4/16/98 3:12p $

'------------------------------------------------------------------------
'
' Purpose:      suivi des commandes envoyes par les concessionnaires,
'               traitement et cration des enregistrements correspondants
'               dans la base de donnes.
' Classes utilises: Wrox Car String Bag
'                    Wrox Car Co Order Processing
' Rfrences:   Microsoft Message Queue Server
'               Microsoft ActiveX Data Objects
'------------------------------------------------------------------------

Private queNewOrder             As MSMQQueue        ' file MSMQ pour les commandes
Private WithEvents evtNewOrder  As MSMQEvent        ' file MSMQ pour les vnements
Attribute evtNewOrder.VB_VarHelpID = -1

' dfinition des diffrentes colonnes de la grille
Private Enum GridColumn
    mconColOrderID = 0
    mconColGarage = 1
    mconColGarageOrderNo = 2
    mconColHOOrderNo = 3
    mconColDateOrdered = 4
    mconColDeliveryDate = 5
    mconColResponseQueue = 6
End Enum

Private Const mconBorderwidth       As Long = 220

Private Sub cmdUpdate_Click()
'
' Objet:        mise  jour de la date de livraison
' Arguments:    aucun
' Returns:      aucun
' Author:       David Sussman
' Date:         17 Mars 1998

    Dim objOrder            As WCCOrderProcessQ.Process     ' objet de traitement des commandes
    Dim intIdx              As Integer                      ' ligne courante
    Dim lngOrderID          As Long                         ' ID de commande
    Dim strResponse         As String                       ' file de rponse
    Dim strHOOrderNumber    As String                       ' rfrence de la commande pour le fabricant
    Dim strDate             As String                       ' date de livraison

    If Not IsDate(txtDeliveryDate) Then
        MsgBox "Attention : la date n'est pas valide. Vous avez le droit de recommencer...", , "Erreur dans la date"
        Exit Sub
    End If
        
    ' obtention de l'id de commande et de la rfrence fabricant
    intIdx = grdOrders.Row
    lngOrderID = GridCellContents(intIdx, mconColOrderID)
    strHOOrderNumber = GridCellContents(intIdx, mconColHOOrderNo)
    strDate = Format$(txtDeliveryDate, "Short Date")

    ' obtention des donnes de la file de rponse
    strResponse = GridCellContents(intIdx, mconColResponseQueue)

    ' mise  jour de la date de livraison
    Set objOrder = CreateObject("WCCOrderProcessQ.Process")
    objOrder.UpdateDeliveryDate lngOrderID, strDate
    SetGridCell lngOrderID, mconColDeliveryDate, strDate
    
    Set objOrder = Nothing

    ' on peut maintenant envoyer un message de rponse au concessionnaire
    RespondToOrder strResponse, GridCellContents(intIdx, mconColGarageOrderNo), strDate, strHOOrderNumber

End Sub

Private Sub evtNewOrder_Arrived(ByVal Queue As Object, ByVal Cursor As Long)
'
' Objet:      grer l'arrive d'une nouvelle commande
' Arguments:    Queue       file MSMQ contenant le message
'               Cursor      position courante du curseur dans cette file
' Retours:      aucun
' Author:       David Sussman
' Date:         17 Mars 1998

    Dim msgReceived     As New MSMQMessage      ' objet correspondant au nouveau message

    ' on extrait message de la file et on effectue le traitement
    Set msgReceived = Queue.Receive

    ProcessOrder msgReceived

    ' on doit rinitialiser pour continuer  ragir  l'arrive de nouveaux message
    queNewOrder.EnableNotification evtNewOrder

End Sub

Private Sub Form_Load()
'
' Objet:        chargement des donnes de la feuille
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    ' cration des objets de file et des objets d'vnment
    Set queNewOrder = New MSMQQueue
    Set evtNewOrder = New MSMQEvent
    
    ' ouverture de la file et lancement de l'avertissement
    Set queNewOrder = MessageQueueOpen("NewOrder", MQ_RECEIVE_ACCESS)
    queNewOrder.EnableNotification evtNewOrder

    ' mise en place des grilles
    GridInitialise
    GridResize
    OrdersNotConfirmed

End Sub

Private Sub ProcessOrder(ByVal msgRec As MSMQMessage)
'
' Objet:      traitement de la commande
' Arguments:    msgRec      message MSMQ reu
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    Dim clsStringBag        As New WroxStringBag.StringBag      ' "sac  chane"
    Dim objOrder            As WCCOrderProcessQ.Process         ' objet de traitement des commandes

    Dim strOrderNumber      As String       ' numro de la commande
    Dim strDeliveryDate     As String       ' date de livraison
    Dim lngOrderID          As Long         ' ID de la commande
    Dim lngInStock          As Long         ' nombre de voitures en stock

    ' on extrait les donnes de la commande  partir du corps (Body) du messsage
    ' qui est une chane srialise.
    clsStringBag.DeSerialize msgRec.Body

    ' on cre un enregitrement pour cette commande dans la base de donnes locale
    Set objOrder = CreateObject("WCCOrderProcessQ.Process")
    objOrder.Create clsStringBag.Item("GarageName"), _
                    clsStringBag.Item("GarageAddress"), _
                    clsStringBag.Item("GarageTown"), _
                    clsStringBag.Item("GarageState"), _
                    clsStringBag.Item("GarageZipCode"), _
                    msgRec.AppSpecific, _
                    clsStringBag.Item("SalesPerson"), _
                    clsStringBag.Item("CustomerName"), _
                    clsStringBag.Item("CustomerAddress"), _
                    clsStringBag.Item("CustomerTown"), _
                    clsStringBag.Item("CustomerState"), _
                    clsStringBag.Item("CustomerZipCode"), _
                    clsStringBag.Item("CustomerPhone"), _
                    CLng(clsStringBag.Item("CarID")), _
                    CLng(clsStringBag.Item("ColorID")), _
                    msgRec.ResponseQueueInfo.FormatName, _
                    strOrderNumber, strDeliveryDate, _
                    lngOrderID, lngInStock
    Set objOrder = Nothing

    ' rafrachissement de l'affichage
    If lngInStock < 0 Then
        strDeliveryDate = "Out of stock"
    End If
    GridAddRow lngOrderID, _
               clsStringBag.Item("GarageName"), _
               msgRec.AppSpecific, _
               strOrderNumber, _
               Format$(Now, "Short Date"), _
               Format$(strDeliveryDate, "Short Date"), _
               msgRec.ResponseQueueInfo.FormatName

    ' on envoie une rponse
    RespondToOrder msgRec.ResponseQueueInfo.FormatName, msgRec.AppSpecific, strDeliveryDate, strOrderNumber
    
End Sub

Private Sub RespondToOrder(strFormatName As String, lngAppSpecific As Long, strLabel As String, strBody As String)
'
' Objet:      envoi d'une rponse aprs traitement de la commande
' Arguments:    strFormatName       nom (FormatName) de la file de rponse
'               lngAppSpecific      proprit AppSpecific du message ; elle contient le numro de commande (concessionnaire)
'               strLabel            proprit Label du message ; elle contient la date de livraision
'               strBody             proprit Body du message ; elle contient la rfrence du fabricant pour cette commande
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    Dim infResponse         As New MSMQQueueInfo    ' infos de la file de rponse
    Dim queResponse         As New MSMQQueue        ' file de rponse
    Dim msgResponse         As New MSMQMessage      ' message de rponse

    ' on ouvre la file de rponse
    infResponse.FormatName = strFormatName
    Set queResponse = infResponse.Open(MQ_SEND_ACCESS, MQ_DENY_NONE)

    ' on construit le message
    msgResponse.AppSpecific = lngAppSpecific
    msgResponse.Label = strLabel
    msgResponse.Body = strBody

    ' on peut maintnenan envoyer le message
    msgResponse.Send queResponse, MQ_NO_TRANSACTION

    queResponse.Close
    Set infResponse = Nothing
    Set msgResponse = Nothing
    Set queResponse = Nothing

End Sub

Private Sub Form_Resize()
'
' Objet:        modifier la taille du formulaire
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    ' on change la taille de la grille
    GridResize

    ' les boutons, le libell et la bote de texte doivent rester visibles
    lblDeliveryDate.Top = Me.ScaleHeight - lblDeliveryDate.Height - mconBorderwidth
    txtDeliveryDate.Top = Me.ScaleHeight - txtDeliveryDate.Height - mconBorderwidth
    cmdUpdate.Top = Me.ScaleHeight - cmdUpdate.Height - mconBorderwidth

    cmdUpdate.Left = Me.ScaleWidth - cmdUpdate.Width - mconBorderwidth
    txtDeliveryDate.Left = cmdUpdate.Left - txtDeliveryDate.Width - mconBorderwidth
    lblDeliveryDate.Left = txtDeliveryDate.Left - lblDeliveryDate.Width - mconBorderwidth

End Sub


Private Sub OrdersNotConfirmed()
'
' Objet:        lecture des commandes en attente de confirmation : au dmarrage on remplit une grille avec les donnes correspondantes
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998
' Note:         cette mthode pourrait appartenir  un objet mtier

    Dim recOrders       As New ADODB.Recordset      ' recordset contenant les commandes non confirmes
    Dim lngOrderID      As Long                     ' ID des commandes
    Dim strResponse     As String                   ' file de rponse
    
    ' obtention des commandes
    recOrders.Open "usp_OrdersNotConfirmed", RegistryRestore("HeadOffice", "Not Set"), adOpenForwardOnly, adLockReadOnly, adCmdStoredProc
    
    ' ajout de commandes dans la grille
    While Not recOrders.EOF
        lngOrderID = recOrders("OrderID")

        If IsNull(recOrders("ResponseQueue")) Then
            strResponse = ""
        Else
            strResponse = recOrders("ResponseQueue")
        End If
            
        GridAddRow lngOrderID, recOrders("GarageName"), _
            recOrders("GarageOrderNumber"), recOrders("HOOrderNumber"), _
            Format$(recOrders("DateOrdered"), "Short Date"), _
            "Out of stock", strResponse

        recOrders.MoveNext
    Wend

    recOrders.Close
    Set recOrders = Nothing

End Sub

Private Sub GridInitialise()
'
' Purpose:      initialisation de la grille
' Arguments:    aucun
' Retours:      aucun
' Author:       David Sussman
' Date:         17 Mars 1998

    With grdOrders
        .Clear
        .Rows = 1
        .Cols = 7
        .FormatString = "<ID de commande|<Garage|>N de commande (garage)|^Rfrence fabricant|^Date de commande|^Date de livraison|RQ"
        .Width = Me.ScaleWidth - mconBorderwidth
        .Height = cmdUpdate.Top - mconBorderwidth - .Top
        
        ' taille des colonnes (on ignore la colonne correspondant  la file de rponse car elle est cache)
        .ColWidth(mconColOrderID) = .Width * 0.1
        .ColWidth(mconColGarage) = .Width * 0.2
        .ColWidth(mconColGarageOrderNo) = .Width * 0.2
        .ColWidth(mconColHOOrderNo) = .Width * 0.2
        .ColWidth(mconColDateOrdered) = .Width * 0.15
        .ColWidth(mconColDeliveryDate) = .Width * 0.15
        .ColWidth(mconColResponseQueue) = 0
    End With

End Sub

Private Sub SetGridCell(ByVal OrderNumber As Long, ByVal Column As GridColumn, ByVal Value As Variant)
'
' Objet:      dfinition du contenu des cellules de la grille
' Arguments:    OrderNumber     numro de la commande
'               Column          colonne dans laquelle on place la valeur
'               Value           valeur
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    Dim intIdx      As Integer      ' ligne de la grille correspondant  la commande

    ' ligne correspondant  la commande
    intIdx = GetGridRow(OrderNumber)

    grdOrders.TextArray(intIdx * grdOrders.Cols + Column) = Value

End Sub

Private Function GridCellContents(ByVal lngRow As Integer, ByVal lngColumn As GridColumn) As Variant
'
' Objet:      rcupration du contenu de la cellule
' Arguments:    lngRow      ligne dans laquelle se trouve la cellule
'               lngColumn   colonne dans laquelle se trouve la cellule
' Retours:      contenu de la cellule
' Auteur:       David Sussman
' Date:         17 Mars 1998

    With grdOrders
        GridCellContents = .TextArray(lngRow * .Cols + lngColumn)
    End With

End Function

Private Function GetGridRow(lngOrderID As Long) As Long
'
' Objet:      obtention de la ligne de la grille  partir du numro de commande
' Arguments:    lngOrderID      ID de commande recherch
' Retours:      ligne de la grille correspondant  l'ID de commande
' Auteur:       David Sussman
' Date:         17 Mars 1998

    Dim intIdx      As Integer      ' index de ligne

    For intIdx = 1 To grdOrders.Rows
        If GridCellContents(intIdx, mconColOrderID) = lngOrderID Then
            GetGridRow = intIdx
            Exit Function
        End If
    Next

End Function

Private Sub GridResize()
'
' Objet:      modification de la taille de la grille
' Arguments:    aucun
' Retours:      aucun
' Author:       David Sussman
' Date:         17 Mars 1998

    Dim intCol              As Integer      ' colonne courante
    Dim intRatio            As Integer      ' largeur de la grille
    Dim adblRatio(6)        As Double       ' ratios

    With grdOrders
        ' enregistrement des rapports "largeur de colonne"/"largeur de feuille"
        For intCol = 0 To .Cols - 2
            adblRatio(intCol) = .ColWidth(intCol) / .Width
        Next

        ' on donne  la grille la largeur et la hauteur de la feuille
        .Width = Me.ScaleWidth - mconBorderwidth
        .Height = cmdUpdate.Top - mconBorderwidth - .Top

        ' pour rcuprer la largeur de chaque colonne on utilise les rapports prcdemment enregistrs
        For intCol = 0 To .Cols - 2
            .ColWidth(intCol) = .Width * adblRatio(intCol)
        Next
    End With

End Sub


Private Sub GridAddRow(ByVal lngOrderID As Long, ByVal strGarageName As String, _
                        ByVal lngGarageOrderNumber As Long, _
                        ByVal strHOOrderNumber As String, ByVal strDateOrdered As String, _
                        ByVal strDeliveryDate As String, ByVal strResponse As String)
'
' Objet:      ajout d'une ligne  la grille
' Arguments:    lngOrderID              ID de la commande
'               strGarageName           nom du concessionnaire
'               lngGarageOrderNumber    numro de commande (concessionnaire)
'               strHOOrderNumber        rfrence du fabricant pour cette commande
'               strDateOrdered          date de la commande
'               strDeliveryDate         date de livraison
'               strResponse             nom (FormatName) de la file de rponse MSMQ
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    grdOrders.AddItem lngOrderID
    SetGridCell lngOrderID, mconColGarage, strGarageName
    SetGridCell lngOrderID, mconColGarageOrderNo, lngGarageOrderNumber
    SetGridCell lngOrderID, mconColHOOrderNo, strHOOrderNumber
    SetGridCell lngOrderID, mconColDateOrdered, strDateOrdered
    SetGridCell lngOrderID, mconColDeliveryDate, strDeliveryDate
    SetGridCell lngOrderID, mconColResponseQueue, strResponse

End Sub

Private Sub grdOrders_Click()
'
' Objet:      activer/dsactiver les options de mise  jour
' Arguments:    aucun
' Returns:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    Dim bEnabled        As Boolean      ' si la valeur est True on peut modifier la grille

    bEnabled = (GridCellContents(grdOrders.Row, mconColDeliveryDate) = "Out of stock")
        
    lblDeliveryDate.Enabled = bEnabled
    txtDeliveryDate.Enabled = bEnabled
    cmdUpdate.Enabled = bEnabled

End Sub
