VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "PaymentTerms"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private mvarTotalPrice      As Currency     ' prix
Private mvarInterestRate    As Single       ' taux
Private mvarMonthlyPayment  As Currency     ' mensualit


Public Function GetNumberPayments() As Integer

   On Error GoTo GetNumberPayments_Error
   
   Dim sngInterestMultiplier    As Single
   Dim curRemainderDue          As Currency
   Dim curFirstMonthInterest    As Currency
   Dim intNumberMonths          As Integer
   Dim objOContext              As ObjectContext
   
   '  obtenir la rfrence  l'objet contexte
   Set objOContext = GetObjectContext()

   ' retourne 0 si calcul impossible
   intNumberMonths = 0
   
   ' voir si paiement suffisant
   curFirstMonthInterest = mvarTotalPrice * mvarInterestRate / 100
   
   If curFirstMonthInterest < mvarMonthlyPayment Then
     sngInterestMultiplier = 1 + (mvarInterestRate / 100)
     curRemainderDue = mvarTotalPrice
     
     Do While curRemainderDue > 0
       curRemainderDue = curRemainderDue * sngInterestMultiplier
       curRemainderDue = curRemainderDue - mvarMonthlyPayment
       intNumberMonths = intNumberMonths + 1
     Loop
   End If
   
   GetNumberPayments = intNumberMonths

   'achve ou choue la transaction
   If intNumberMonths > 0 Then
      objOContext.SetComplete
   Else
      objOContext.SetAbort
   End If

GetNumberPayments_Exit:
    Exit Function

GetNumberPayments_Error:
    GetNumberPayments = 0  'indique une erreur
    objOContext.SetAbort   'choue le contexte MTS
    Resume GetNumberPayments_Exit

End Function

Public Property Let MonthlyPayment(ByVal vData As Currency)
Attribute MonthlyPayment.VB_Description = "Ce que le client peut payer par mois. Utilis pour calculer le nombre de paiements requis."
    
    If vData > 0 Then
        mvarMonthlyPayment = vData
    End If

End Property

Public Property Let InterestRate(ByVal vData As Single)
Attribute InterestRate.VB_Description = "le taux de 0  99 utilis pour calculer le nombre de paiements."
    
    If vData >= 0 And vData < 100 Then
        mvarInterestRate = vData
    End If

End Property

Public Property Let TotalPrice(ByVal vData As Currency)
Attribute TotalPrice.VB_Description = "fixe le prix total du vhicule pour calculer le nomnbre de paiements."

    If vData > 0 Then
        mvarTotalPrice = vData
    End If

End Property


