VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "OrderMonitorQ"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"34F5AE6C00A2"
Option Explicit

'-----------------------------------------------------------------------------
' But :      Surveiller l'volution de la file de rponse et de la file d'acquittement.
'            Afficher le contenu des messages.
' Classes employes : Wrox Car Co Showroom Ordering
' Rfrences :   Microsoft Message Queue Server
'-----------------------------------------------------------------------------

' dclaration des files de messages et des vnements MSMQ
Private queResponse             As MSMQQueue
Private queAck                  As MSMQQueue
Private WithEvents evtResponse  As MSMQEvent
Attribute evtResponse.VB_VarHelpID = -1
Private WithEvents evtAck       As MSMQEvent
Attribute evtAck.VB_VarHelpID = -1

' on dfinit les valeur  communiquer en retour  l'appelant
Event OrderResponse(OrderNumber As Long, DeliveryDate As String, HOOrderNumber As String)
Attribute OrderResponse.VB_Description = "Reponsd to a message in the response queue"
Event OrderAck(OrderNumber As Long, Class As Long)
Attribute OrderAck.VB_Description = "Respond to a message in the acknowledgement queue"

' dlcaration d'un objet de cration de commande ct concessionnaire
Private objShowroom                 As WCCSROrderQ.ShowroomOrderQ

Private Sub Class_Terminate()
'
' But:          librer toutes les ressources
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman

    Set queResponse = Nothing
    Set queAck = Nothing
    Set evtResponse = Nothing
    Set evtAck = Nothing

End Sub

Private Sub evtAck_Arrived(ByVal Queue As Object, ByVal Cursor As Long)
'
' But:      Traiter un message d'acquittement (c--d msg.Ack)
' Arguments:    Queue       file (MSMQQueue) ayant reu le message
'               Cursor      position du curseur dans cette file
' Retours:      aucun
' Auteur:       David Sussman

    Dim msgAck      As MSMQMessage      ' message d'acquittement
    
    ' extraction du message
    Set msgAck = Queue.Receive(WantBody:=False)

    ' MAJ de l'acquittement dans la base de donnes du concessionnaire
    Set objShowroom = New WCCSROrderQ.ShowroomOrderQ
    objShowroom.UpdateAck (msgAck.AppSpecific)
    Set objShowroom = Nothing

    ' on indique ensuite  l'appelant ce qui s'est produit
    RaiseEvent OrderAck(msgAck.AppSpecific, msgAck.Class)

    ' et on rinitialise la notification sur cette file de messages
    queAck.EnableNotification evtAck

    Set msgAck = Nothing

End Sub

Private Sub evtResponse_Arrived(ByVal Queue As Object, ByVal Cursor As Long)
'
' But:      Traiter les messages de rponse.
' Arguments:    Queue       file (MSMQQueue) ayant reu la rponse
'               Cursor      position du curseur dans cette file
' Retours:      aucun
' Auteur:       David Sussman

    Dim msgResp     As MSMQMessage      ' message de rponse
    Dim vardate     As Variant          ' date de livraison

    ' extraction du message
    Set msgResp = Queue.Receive

    ' MAJ de l'enregistrement dans la base de donnes du concessionnaire
    Set objShowroom = New WCCSROrderQ.ShowroomOrderQ
    
    ' le libell contient la date de livraison ou bien "Out of Stock"
    If IsDate(msgResp.Label) Then
        vardate = msgResp.Label
    Else
        vardate = Null
    End If

    objShowroom.UpdateDelivery msgResp.AppSpecific, msgResp.Body, vardate
    Set objShowroom = Nothing

    ' on renseigne maintenant l'appelant sur ce qui vient d'arrver
    RaiseEvent OrderResponse(msgResp.AppSpecific, msgResp.Label, msgResp.Body)

    ' et on rinitialise la notification sur cette file
    queResponse.EnableNotification evtResponse

    Set msgResp = Nothing

End Sub

Private Sub Class_Initialize()
'
' But:      Initialisation des files que l'on veut surveiller
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman

    ' on dfinit les vnements MSMQ
    ' ...d'abord pour la file d'acquittement
    Set queAck = New MSMQQueue
    Set evtAck = New MSMQEvent
    Set queAck = MessageQueueOpen(mcstrOrderAck, MQ_RECEIVE_ACCESS)
    queAck.EnableNotification evtAck

    ' ...ensuite pour la file de rponse
    Set queResponse = New MSMQQueue
    Set evtResponse = New MSMQEvent
    Set queResponse = MessageQueueOpen(mcstrOrderResponse, MQ_RECEIVE_ACCESS)
    queResponse.EnableNotification evtResponse
    
End Sub
