/* Script de cration de base de donnes pour Eyrolles Royce
//
// Ce script cre la base de donnes WroxCarCoHeadOffice (fabricant)
*/

/* Cration des units de base de donnes - une pour la base et une pour le fichier journal 
//
// Vous devrez probablement changer :
//	PHYSNAME	nom du fichier qui stocke physiquement la base. 
//			Vous pouvez le placer sur n'importe auel disaue accessible 
//	SIZE		Taille de la base de donnes (par pages de 2Ko).
//			On a donc 10 Mo au lieu de 5120 octets.
//
// REMARQUE :	Ne vous inquitez pas si vous recevez un message indiquant que l'unit virtuelle est en cours d'utilisation.
//		Si vous essayez de le rutiliser SQL Server en allouera un nouveau.
*/
USE master
GO

DISK INIT
	NAME='WroxCarCoHO',
	PHYSNAME='C:\MSSQL\DATA\WroxCarCoHO.dat',
	VDEVNO=100,
	SIZE=5120
GO

DISK INIT
	NAME='WroxCarCoHOLog',
	PHYSNAME='C:\MSSQL\DATA\WroxCarCoLogHO.dat',
	VDEVNO=101,
	SIZE=1536
GO

/* Cration de la base de donnes 
// On utilise les champs NAME prcdents. Attention les chiffres correspondent  des Mo et non  des pages
//
// REMARQUE :	Ne changez pas le nom de la base de donnes.
*/

CREATE DATABASE WroxCarCoHeadOffice
	ON WroxCarCoHO=10
	LOG ON WroxCarCoHOLog=3
GO
