/* Microsoft SQL Server - Scripting			*/
/* Server: PIGLET					*/
/* Database: WroxCarCo					*/
/* Creation Date 3/26/98 3:17:38 PM 			*/

USE WroxCarCo
GO

/****** Object:  Stored Procedure dbo.usp_AllColorsForAllCars    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_AllColorsForAllCars') and sysstat & 0xf = 4)
	drop procedure dbo.usp_AllColorsForAllCars
GO

/****** Object:  Stored Procedure dbo.usp_ColorsByCar    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_ColorsByCar') and sysstat & 0xf = 4)
	drop procedure dbo.usp_ColorsByCar
GO

/****** Object:  Stored Procedure dbo.usp_OrderInsert    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_OrderInsert') and sysstat & 0xf = 4)
	drop procedure dbo.usp_OrderInsert
GO

/****** Object:  Stored Procedure dbo.usp_OrderUpdate    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_OrderUpdate') and sysstat & 0xf = 4)
	drop procedure dbo.usp_OrderUpdate
GO

/****** Object:  Stored Procedure dbo.usp_OrderUpdateAck    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_OrderUpdateAck') and sysstat & 0xf = 4)
	drop procedure dbo.usp_OrderUpdateAck
GO

/****** Object:  Stored Procedure dbo.usp_OrderUpdateDelivery    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_OrderUpdateDelivery') and sysstat & 0xf = 4)
	drop procedure dbo.usp_OrderUpdateDelivery
GO

/****** Object:  Stored Procedure dbo.usp_OrdersConfirmed    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_OrdersConfirmed') and sysstat & 0xf = 4)
	drop procedure dbo.usp_OrdersConfirmed
GO

/****** Object:  Stored Procedure dbo.usp_OrdersNotConfirmed    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_OrdersNotConfirmed') and sysstat & 0xf = 4)
	drop procedure dbo.usp_OrdersNotConfirmed
GO

/****** Object:  Stored Procedure dbo.usp_OrdersUnconfirmed    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_OrdersUnconfirmed') and sysstat & 0xf = 4)
	drop procedure dbo.usp_OrdersUnconfirmed
GO

/****** Object:  Stored Procedure dbo.usp_Cars    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_Cars') and sysstat & 0xf = 4)
	drop procedure dbo.usp_Cars
GO

/****** Object:  Stored Procedure dbo.usp_CustomerInsert    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_CustomerInsert') and sysstat & 0xf = 4)
	drop procedure dbo.usp_CustomerInsert
GO

/****** Object:  Table dbo.tblCarColor    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.tblCarColor') and sysstat & 0xf = 3)
	drop table dbo.tblCarColor
GO

/****** Object:  Table dbo.tblOrder    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.tblOrder') and sysstat & 0xf = 3)
	drop table dbo.tblOrder
GO

/****** Object:  Table dbo.tblCar    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.tblCar') and sysstat & 0xf = 3)
	drop table dbo.tblCar
GO

/****** Object:  Table dbo.tblColor    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.tblColor') and sysstat & 0xf = 3)
	drop table dbo.tblColor
GO

/****** Object:  Table dbo.tblCustomer    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.tblCustomer') and sysstat & 0xf = 3)
	drop table dbo.tblCustomer
GO

/****** Object:  Default dbo.UW_ZeroDefault    Script Date: 3/26/98 3:17:47 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.UW_ZeroDefault') and sysstat & 0xf = 6)
	drop default dbo.UW_ZeroDefault
GO

/****** Object:  Default dbo.UW_ZeroDefault    Script Date: 3/26/98 3:17:47 PM ******/

/****** Object:  Default dbo.UW_ZeroDefault    Script Date: 04/03/98 16:38:40 ******/
CREATE DEFAULT dbo.UW_ZeroDefault AS 0


GO

/****** Object:  Table dbo.tblCar    Script Date: 3/26/98 3:17:47 PM ******/
CREATE TABLE dbo.tblCar (
	CarID int IDENTITY (1, 1) NOT NULL ,
	Model varchar (50) NULL ,
	EngineSize smallint NULL ,
	Doors smallint NULL ,
	Seats smallint NULL ,
	Price numeric(18, 0) NULL ,
	Picture varchar (255) NULL ,
	Description text NULL ,
	CONSTRAINT aaaaatblCar_PK PRIMARY KEY  NONCLUSTERED 
	(
		CarID
	)
)
GO

 CREATE  INDEX CarID ON dbo.tblCar(CarID)
GO

setuser 'dbo'
GO

EXEC sp_bindefault 'dbo.UW_ZeroDefault', 'tblCar.Doors'
GO

EXEC sp_bindefault 'dbo.UW_ZeroDefault', 'tblCar.EngineSize'
GO

EXEC sp_bindefault 'dbo.UW_ZeroDefault', 'tblCar.Seats'
GO

setuser
GO

GRANT  SELECT  ON tblCar  TO public
GO

/****** Object:  Table dbo.tblColor    Script Date: 3/26/98 3:17:49 PM ******/
CREATE TABLE dbo.tblColor (
	ColorID int IDENTITY (1, 1) NOT NULL ,
	Color varchar (50) NULL ,
	ColorHTM varchar(50) NULL ,
	CONSTRAINT aaaaatblColour_PK PRIMARY KEY  NONCLUSTERED 
	(
		ColorID
	)
)
GO

 CREATE  INDEX ColourID ON dbo.tblColor(ColorID)
GO

GRANT  SELECT  ON tblColor  TO public
GO

/****** Object:  Table dbo.tblCustomer    Script Date: 3/26/98 3:17:49 PM ******/
CREATE TABLE dbo.tblCustomer (
	CustomerID int IDENTITY (1, 1) NOT NULL ,
	Name varchar (50) NULL ,
	Address varchar (50) NULL ,
	Town varchar (50) NULL ,
	State varchar (2) NULL ,
	ZipCode varchar (15) NULL ,
	Phone varchar (15) NULL ,
	CONSTRAINT aaaaatblCustomer_PK PRIMARY KEY  NONCLUSTERED 
	(
		CustomerID
	)
)
GO

 CREATE  INDEX CustomerID ON dbo.tblCustomer(CustomerID)
GO

 CREATE  INDEX PostCode ON dbo.tblCustomer(State)
GO

GRANT  SELECT ,  INSERT ,  UPDATE  ON tblCustomer  TO public
GO

/****** Object:  Table dbo.tblCarColor    Script Date: 3/26/98 3:17:49 PM ******/
CREATE TABLE dbo.tblCarColor (
	CarColorID int IDENTITY (1, 1) NOT NULL ,
	fkCarID int NOT NULL ,
	fkColorID int NOT NULL ,
	InStock smallint NULL ,
	CONSTRAINT PK_tblCarColor PRIMARY KEY  NONCLUSTERED 
	(
		CarColorID
	),
	CONSTRAINT FK_tblCarColor_tblCar FOREIGN KEY 
	(
		fkCarID
	) REFERENCES dbo.tblCar (
		CarID
	),
	CONSTRAINT FK_tblCarColor_tblColor FOREIGN KEY 
	(
		fkColorID
	) REFERENCES dbo.tblColor (
		ColorID
	)
)
GO

GRANT  SELECT ,  UPDATE  ON tblCarColor  TO public
GO

/****** Object:  Table dbo.tblOrder    Script Date: 3/26/98 3:17:50 PM ******/
CREATE TABLE dbo.tblOrder (
	OrderID int IDENTITY (1, 1) NOT NULL ,
	fkCustomerID int NULL ,
	OrderDate datetime NULL ,
	fkCarID int NULL ,
	SalesPerson varchar (20) NULL ,
	Acknowledged bit NOT NULL CONSTRAINT DF_tblOrder_Acknowleged_1__11 DEFAULT (0),
	DeliveryDate datetime NULL ,
	HOOrderNumber char (10) NULL ,
	PricePaid numeric(18, 0) NULL ,
	fkColorID int NULL ,
	CONSTRAINT aaaaatblOrder_PK PRIMARY KEY  NONCLUSTERED 
	(
		OrderID
	),
	CONSTRAINT FK__Temporary__fkCus__15EF4CF6 FOREIGN KEY 
	(
		fkCustomerID
	) REFERENCES dbo.tblCustomer (
		CustomerID
	),
	CONSTRAINT FK_tblOrder_tblCar FOREIGN KEY 
	(
		fkCarID
	) REFERENCES dbo.tblCar (
		CarID
	),
	CONSTRAINT FK_tblOrder_tblColor FOREIGN KEY 
	(
		fkColorID
	) REFERENCES dbo.tblColor (
		ColorID
	)
)
GO

 CREATE  INDEX fkCarID ON dbo.tblOrder(fkCarID)
GO

 CREATE  INDEX fkCustomerID ON dbo.tblOrder(fkCustomerID)
GO

 CREATE  INDEX OrderID ON dbo.tblOrder(OrderID)
GO

 CREATE  INDEX tblCartblOrder ON dbo.tblOrder(fkCarID)
GO

 CREATE  INDEX tblCustomertblOrder ON dbo.tblOrder(fkCustomerID)
GO

GRANT  SELECT ,  INSERT ,  UPDATE  ON tblOrder  TO public
GO

/****** Object:  Stored Procedure dbo.usp_Cars    Script Date: 3/26/98 3:17:50 PM ******/
/****** Object:  Stored Procedure dbo.usp_Cars    Script Date: 04/03/98 16:38:42 ******/
Create Procedure usp_Cars
As
	SELECT	*
	FROM	tblCar
	ORDER BY CarID
GO

GRANT  EXECUTE  ON dbo.usp_Cars  TO public
GO

/****** Object:  Stored Procedure dbo.usp_CustomerInsert    Script Date: 3/26/98 3:17:50 PM ******/
/****** Object:  Stored Procedure dbo.usp_CustomerInsert    Script Date: 04/03/98 16:38:42 ******/
Create Procedure usp_CustomerInsert	@Name			varchar(50),
					@Address		varchar(50),
					@Town			varchar(50),
					@State			varchar(2),
					@ZipCode		varchar(15),
					@Phone			varchar(15)
AS
/*
// But :	Insrer un enregistrement dans la table des clients 
//          et retourner un ID (si le client existe dj on retourne 
//		l'ID et c'est tout).
//
// Historique des modifications 
// Date		Auteur		Description
// 15 Fv 1998	David Sussman	Premire version
// 
*/
	SET NOCOUNT OFF

	DECLARE @CID	integer		-- ID pour le client 
	SELECT	@CID	= -1

	-- on vrifie si un enregistrement existe dj 
	SELECT	@CID = CustomerID
	FROM	tblCustomer
	WHERE	Name	= @Name
	AND		Address	= @Address
	AND		Town	= @Town
	AND		State	= @State
	AND		ZipCode	= @ZipCode
	AND		Phone	= @Phone
	
	-- si ce n'est pas le cas on insre un nouvel enregistrement
	If @CID = -1
	BEGIN
		INSERT INTO tblCustomer (Name, Address, Town, State, ZipCode, Phone)
		VALUES (@Name, @Address, @Town, @State, @ZipCode, @Phone)

		SELECT @CID = @@IDENTITY
	END

	SET NOCOUNT ON

	RETURN @CID
GO

GRANT  EXECUTE  ON dbo.usp_CustomerInsert  TO public
GO

/****** Object:  Stored Procedure dbo.usp_AllColorsForAllCars    Script Date: 3/26/98 3:17:50 PM ******/
/****** Object:  Stored Procedure dbo.usp_AllColorsForAllCars    Script Date: 04/03/98 16:38:42 ******/
Create Procedure usp_AllColorsForAllCars
As
	SELECT	tblCarColor.fkCarID, tblColor.ColorID, tblColor.Color, tblColor.ColorHTM
	FROM	tblCarColor, tblColor
	WHERE	tblCarColor.fkColorID = tblColor.ColorID
	ORDER BY tblCarColor.fkCarID, tblColor.ColorID
GO

GRANT  EXECUTE  ON dbo.usp_AllColorsForAllCars  TO public
GO

/****** Object:  Stored Procedure dbo.usp_ColorsByCar    Script Date: 3/26/98 3:17:51 PM ******/

/****** Object:  Stored Procedure dbo.usp_ColorsByCar    Script Date: 04/03/98 16:38:42 ******/
Create Procedure usp_ColorsByCar
		@CarID		integer
As
	SELECT	tblColor.*
	FROM	tblCarColor, tblColor
	WHERE	tblCarColor.fkColorID = tblColor.ColorID
	AND		tblCarColor.fkCarID = @CarID
	ORDER BY tblColor.ColorID

GO

GRANT  EXECUTE  ON dbo.usp_ColorsByCar  TO public
GO

/****** Object:  Stored Procedure dbo.usp_OrderInsert    Script Date: 3/26/98 3:17:51 PM ******/
/****** Object:  Stored Procedure dbo.usp_OrderInsert    Script Date: 04/03/98 16:38:42 ******/
CREATE PROCEDURE usp_OrderInsert	
					@CarID			integer,
					@ColorID		integer,
					@SalesPerson	varchar(20),
					@PricePaid		numeric,
					@Name			varchar(50),
					@Address		varchar(50),
					@Town			varchar(50),
					@State			varchar(2),
					@ZipCode		varchar(15),
					@Phone			varchar(15),
					@OrderNumber	int OUTPUT
AS
/*
// But :	Insrer un enregistrement dans la table des commandes 
//          du concessionnaire. 
//		On ajoute aussi les donnes concernant le client dans une autre table.
//
// Historique des modifications 
// Date		Auteur		Description
// 15 Fv 1998	David Sussman	Premire version
// 
*/

BEGIN
	DECLARE @CID		integer

	-- Insertion des donns concernant l'acheteur 
	EXEC @CID = usp_CustomerInsert @Name, @Address, @Town, @State, @ZipCode, @Phone

-- Insertion de la commnde elle-mme 
select @CarID, @ColorID, @CID, @SalesPerson, @PricePaid, GETDATE()
	INSERT INTO tblOrder (fkCarID, fkColorID, fkCustomerID, SalesPerson, PricePaid, OrderDate)
	VALUES (@CarID, @ColorID, @CID, @SalesPerson, @PricePaid, GETDATE())

	-- on retourne un ID pour la commande 
	SELECT @OrderNumber = @@IDENTITY
END
GO

GRANT  EXECUTE  ON dbo.usp_OrderInsert  TO public
GO

/****** Object:  Stored Procedure dbo.usp_OrderUpdate    Script Date: 3/26/98 3:17:51 PM ******/
/****** Object:  Stored Procedure dbo.usp_OrderUpdate    Script Date: 04/03/98 16:38:42 ******/
CREATE PROCEDURE usp_OrderUpdate
		@OrderID	int,
		@HOOrderNumber	varchar(10),
		@DeliveryDate	datetime
AS
/*
// But :	Mettre  jour une commande dans la table du concessionnaire 
//           partir des informations renvoyes par le fabricant. 
//
// Historique des modifications 
// Date		Auteur		Description
// 19 Fv 1998	David Sussman	Premire version
// 
*/

	UPDATE	tblOrder
	SET		HOOrderNumber	= @HOOrderNumber,
			DeliveryDate	= @DeliveryDate
	WHERE	OrderID = @OrderID
GO

GRANT  EXECUTE  ON dbo.usp_OrderUpdate  TO public
GO

/****** Object:  Stored Procedure dbo.usp_OrderUpdateAck    Script Date: 3/26/98 3:17:51 PM ******/
CREATE PROCEDURE usp_OrderUpdateAck
		@OrderID		int
AS
/*
// But :	Mise  jour de la commande dans la table du concessionnaire 
//          notamment avec le numro de commande envoy par le fabricant
//
// Historique des modifications 
// Date		Auteur		Description
// 12 Mar 1998	David Sussman	Premire version
// 
*/

	UPDATE	tblOrder
	SET	Acknowledged	= 1
	WHERE	OrderID = @OrderID
GO

GRANT  EXECUTE  ON dbo.usp_OrderUpdateAck  TO public
GO

/****** Object:  Stored Procedure dbo.usp_OrderUpdateDelivery    Script Date: 3/26/98 3:17:51 PM ******/
CREATE PROCEDURE usp_OrderUpdateDelivery
		@OrderID	int,
		@HOOrderNumber	varchar(10),
		@DeliveryDate	datetime = ""
AS
/*
// But :	Mise  jour de la commande dans la table du concessionnaire 
//          notamment avec la date de livraison renvoy par le fabricant
//
// Historique des modifications 
// Date		Auteur		Description
// 19 Mar 1998	David Sussman	Premire version
// 
*/

	UPDATE	tblOrder
	SET	HOORderNumber	= @HOOrderNumber,
		DeliveryDate	= @DeliveryDate
	WHERE	OrderID = @OrderID
GO

GRANT  EXECUTE  ON dbo.usp_OrderUpdateDelivery  TO public
GO

/****** Object:  Stored Procedure dbo.usp_OrdersConfirmed    Script Date: 3/26/98 3:17:51 PM ******/
CREATE PROCEDURE usp_OrdersConfirmed
AS
	SELECT	'Order Number' = OrderID, 
		'Date Ordered' = OrderDate,
		Acknowledged,
		'Head Office Order' = HOOrderNumber, 
		'Delivery Date' = DeliveryDate
	FROM	tblOrder
	WHERE	DeliveryDate IS NOT NULL
	ORDER BY OrderID DESC
GO

GRANT  EXECUTE  ON dbo.usp_OrdersConfirmed  TO public
GO

/****** Object:  Stored Procedure dbo.usp_OrdersNotConfirmed    Script Date: 3/26/98 3:17:51 PM ******/
CREATE PROCEDURE usp_OrdersNotConfirmed
AS
	SELECT	*
	FROM	tblOrder
	WHERE	DeliveryDate IS NULL
	OR	DeliveryDate = 'Jan 1 1900 12:00AM'
GO

GRANT  EXECUTE  ON dbo.usp_OrdersNotConfirmed  TO public
GO

/****** Object:  Stored Procedure dbo.usp_OrdersUnconfirmed    Script Date: 3/26/98 3:17:51 PM ******/
CREATE PROCEDURE usp_OrdersUnconfirmed
AS
	SELECT	'Order Number' = OrderID, 
		'Date Ordered' = OrderDate,
		Acknowledged,
		'Head Office Order' = HOOrderNumber, 
		'Delivery Date' = DeliveryDate
	FROM	tblOrder
	WHERE	DeliveryDate IS NULL
	ORDER BY OrderID DESC
GO

GRANT  EXECUTE  ON dbo.usp_OrdersUnconfirmed  TO public
GO

