Attribute VB_Name = "Queue"
Option Explicit

' $Version: $
' $Auteur: Davids $
' Date: $

' Noms des files s
Public Const mcstrNewOrder         As String = "NewOrder"
Public Const mcstrOrderResponse    As String = "OrderResponse"
Public Const mcstrOrderAck         As String = "OrderAcknowledgement"

' information registry
Private Const mcstrRegNotFound      As String = "<Not Found>"

Public Function MessageQueueOpen(ByVal strQueueName As String, ByVal intAccess As MQACCESS) As MSMQQueue
'
' Objet:        ouverture d'une file
' Arguments:    strQueueName        file  ouvrir
'               intAccess           mode d'accs demand
' Retours:      la structure MSMQQueue de la file

    On Error GoTo MessageQueueOpen_Err

    Dim strGUID         As String               ' GUID de la file
    Dim infQ            As New MSMQQueueInfo    ' info file
    Dim bFirstTry       As Boolean              ' vrai 1ere ouverture de la file

    bFirstTry = True

    ' recherche du GUID de la file dans la registry
    strGUID = RegistryRestore(strQueueName, mcstrRegNotFound)

    If strGUID = mcstrRegNotFound Then
        ' non trouv, recherche par nom
        strGUID = GetQueueGUID(strQueueName)

        ' sauvegarde dans la registry
        RegistrySave strQueueName, strGUID
    End If
    
    ' ouverture de la file
    infQ.FormatName = "PUBLIC=" & strGUID
    Set MessageQueueOpen = infQ.Open(intAccess, MQ_DENY_NONE)

MessageQueueOpen_Exit:
    If Not infQ Is Nothing Then
        Set infQ = Nothing
    End If
    Exit Function

MessageQueueOpen_Err:
    ' si la file n'est pas enregistre, on a du la trouver dans la registry
    ' mais l'ID n'est pas le bon. Ceci peut arriver si la file est suprime et recre
    
    If bFirstTry And Err.Number = MQ_ERROR_QUEUE_NOT_FOUND Then
        ' on dfinit la valeur du flag pour ne pas continuer  ouvrir la file de messages
        bFirstTry = False

        strGUID = GetQueueGUID(strQueueName)
        
        ' sauvegarde dans la registry
        RegistrySave strQueueName, strGUID
        
        ' ouverture de la file
        infQ.FormatName = "PUBLIC=" & strGUID
        Set MessageQueueOpen = infQ.Open(intAccess, MQ_DENY_NONE)
        Resume MessageQueueOpen_Exit
    End If

    ' dfinitivement impossible d'ouvrir la file
    If Not infQ Is Nothing Then
        Set infQ = Nothing
    End If
    Err.Raise Err.Number, "MessageQueueOpen", Err.Description
    Resume MessageQueueOpen_Exit

End Function

Private Function GetQueueGUID(strQueueName As String) As String
'
' Objet:        recherche du GUID par le nom de la file
' Arguments:    strQueueName        nom cherch
' Retours:      GUID de la file trouve
' Notes:        lve une erreur si plus d'une file trouve

    Dim qryQ        As New MSMQQuery        ' requte de file
    Dim infQueues   As MSMQQueueInfos       ' info file
    Dim infQ        As MSMQQueueInfo        ' info file trouve
    Dim infQTmp     As MSMQQueueInfo        ' copie temporaire
    Dim intQueues   As Integer              ' nombre de files trouves
    
    ' recherche des files correspondantes
    Set infQueues = qryQ.LookupQueue(Label:=strQueueName)

    ' obtenir la 1ere
    infQueues.Reset
    Set infQTmp = infQueues.Next

    ' boucle sur les autres
    While Not (infQTmp Is Nothing)
        Set infQ = infQTmp
        intQueues = intQueues + 1
        
        ' lecture suivante
        Set infQTmp = infQueues.Next
    Wend
    
    ' test nombre files trouves et chec si plus d'une
    If intQueues <> 1 Then
        Err.Raise vbObjectError + 10, "GetQueueGUID", "Plus d'une file trouve!"
    End If

    ' retour du GUID (sans les {})
    GetQueueGUID = Mid$(infQ.QueueGuid, 2, Len(infQ.QueueGuid) - 2)

End Function
