VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Process"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"34F5AE6C00A2"
Option Explicit

' $Revision: 2 $
' $Author: Davids $
' $Date: 4/16/98 3:12p $

'------------------------------------------------------------------------
'
' Objet:        traitement des commandes envoyes par les concessionnaires
' Classes utilises: Wrox String Bag
' Rfrences:   Microsoft ActiveX Data Objects
'               Microsoft Transcation Server
'------------------------------------------------------------------------

Public Function Create(ByVal GarageName As String, ByVal GarageAddress As String, _
                       ByVal GarageTown As String, ByVal GarageState As String, _
                       ByVal GarageZipCode As String, ByVal GarageOrderNumber As Long, _
                       ByVal SalesPerson As String, ByVal CustomerName As String, _
                       ByVal CustomerAddress As String, ByVal CustomerTown As String, _
                       ByVal CustomerState As String, ByVal CustomerZipCode As String, _
                       ByVal CustomerPhone As String, ByVal CarID As Long, _
                       ByVal ColorID As Long, _
                       ByVal ResponseQueue As String, _
                       ByRef OrderNumber As Variant, _
                       ByRef DeliveryDate As Variant, _
                       ByRef OrderID As Variant, _
                       ByRef NumberInStock As Variant, _
                       Optional ConnectionString As Variant) As Boolean
Attribute Create.VB_Description = "Create the order from a showroom"
'
' Objet:        cration d'un enregistrement dans la base de donnes du fabricant
' Arguments:    donnes correspondant  la commande
' Retours:      True si l'enregistrement a pu tre cr, False sinon
' Auteur:       David Sussman
' Date:         15 Fv 1998

    On Error GoTo Create_Err

    Dim comC        As New ADODB.Command        ' commande  excuter
    Dim objContext  As ObjectContext            ' contexte MTS

    ' rcupration du contexte MTS pour la transaction
    Set objContext = GetObjectContext

    With comC
        ' dfinition du type de commande
        If IsMissing(ConnectionString) Then
            .ActiveConnection = RegistryRestore("HeadOffice", "Not Set")
        Else
            .ActiveConnection = ConnectionString
        End If
        .CommandType = adCmdStoredProc
        .CommandText = "usp_OrderInsertQ"

        ' dfinition des paramtres de la commande
        With .Parameters
            .Append comC.CreateParameter("Return", adVarChar, adParamReturnValue, 8)
            .Append comC.CreateParameter("@GarageName", adVarChar, adParamInput, 50, GarageName)
            .Append comC.CreateParameter("@GarageAddress", adVarChar, adParamInput, 50, GarageAddress)
            .Append comC.CreateParameter("@GarageTown", adVarChar, adParamInput, 20, GarageTown)
            .Append comC.CreateParameter("@GarageState", adVarChar, adParamInput, 2, GarageState)
            .Append comC.CreateParameter("@GarageZipCode", adVarChar, adParamInput, 15, GarageZipCode)
            .Append comC.CreateParameter("@GarageOrderNumber", adInteger, adParamInput, 8, GarageOrderNumber)
            .Append comC.CreateParameter("@SalesPerson", adVarChar, adParamInput, 20, SalesPerson)
            .Append comC.CreateParameter("@CustomerName", adVarChar, adParamInput, 20, CustomerName)
            .Append comC.CreateParameter("@CustomerAddress", adVarChar, adParamInput, 50, CustomerAddress)
            .Append comC.CreateParameter("@CustomerTown", adVarChar, adParamInput, 20, CustomerTown)
            .Append comC.CreateParameter("@CustomerState", adVarChar, adParamInput, 2, CustomerState)
            .Append comC.CreateParameter("@CustomerZipCode", adVarChar, adParamInput, 15, CustomerZipCode)
            .Append comC.CreateParameter("@CustomerPhone", adVarChar, adParamInput, 15, CustomerPhone)
            .Append comC.CreateParameter("@CarID", adInteger, adParamInput, 8, CarID)
            .Append comC.CreateParameter("@ColorID", adInteger, adParamInput, 8, ColorID)
            .Append comC.CreateParameter("@ResponseQueue", adVarChar, adParamInput, 255, ResponseQueue)
            .Append comC.CreateParameter("@OrderNumber", adVarChar, adParamOutput, 10)
            .Append comC.CreateParameter("@DeliveryDate", adDBTimeStamp, adParamOutput, 8)
            .Append comC.CreateParameter("@OrderID", adInteger, adParamOutput, 8)
        End With

        ' excution de la commande
        .Execute

        ' rcupration des paramtres de sortie
        NumberInStock = .Parameters("Return")
        OrderNumber = .Parameters("@OrderNumber")
        If IsNull(.Parameters("@DeliveryDate")) Then
            DeliveryDate = ""
        Else
            DeliveryDate = .Parameters("@DeliveryDate")
        End If
        OrderID = .Parameters("@OrderID")
    End With

    Create = True

    ' on indique  MTS que l'opration s'est droule avec succs
    objContext.SetComplete

Create_Exit:
    ' nettoyage et sortie
    If Not comC Is Nothing Then
        Set comC = Nothing
    End If
    If Not objContext Is Nothing Then
        Set objContext = Nothing
    End If
    Exit Function

Create_Err:
    Create = False

    ' on indique  MTS que l'opration ne s'est pas droule de manire satisfaisante
    objContext.SetAbort

    Err.Raise Err.Number, "WWCCHOOrder.Create", Err.Description

    Resume Create_Exit

End Function

Public Function UpdateDeliveryDate(ByVal OrderID As Long, _
                                   ByVal DeliveryDate As Date, _
                                   Optional ConnectionString As Variant) As Boolean
Attribute UpdateDeliveryDate.VB_Description = "Update the delivery date of an order"
'
' Objet:      mise  jour de la date de livraison pour cette commande
' Arguments:    OrderID         ID de la commande
'               DeliveryDate    date de livraison
' Retours:      True si la mise  jour russit, False sinon
' Auteur:       David Sussman
' Date:         15 Mars 1998

    On Error GoTo UpdateDeliveryDate_Err

    Dim comC        As New ADODB.Command        ' Commande  excuter
    Dim objContext  As ObjectContext            ' contexte MTS

    ' rcupration du contexte MTS pour la transaction
    Set objContext = GetObjectContext

    With comC
        ' on dfinit le type de la commande
        If IsMissing(ConnectionString) Then
            .ActiveConnection = RegistryRestore("HeadOffice", "Not Set")
        Else
            .ActiveConnection = ConnectionString
        End If
        .CommandType = adCmdStoredProc
        .CommandText = "usp_OrderUpdateDeliveryDate"

        ' on dfinit les paramtres de la commande
        With .Parameters
            .Append comC.CreateParameter("@OrderID", adInteger, adParamInput, 8, OrderID)
            .Append comC.CreateParameter("@DeliveryDate", adDBTimeStamp, adParamInput, 8, DeliveryDate)
        End With

        ' on peut maintenant excuter la commande
        .Execute
    End With

    UpdateDeliveryDate = True

    ' on indique  MTS que l'opration a pu tre mene  terme
    objContext.SetComplete

UpdateDeliveryDate_Exit:
    ' nettoyage et sortie
    If Not comC Is Nothing Then
        Set comC = Nothing
    End If
    If Not objContext Is Nothing Then
        Set objContext = Nothing
    End If
    Exit Function

UpdateDeliveryDate_Err:
    UpdateDeliveryDate = False

    ' on indique  MTS que l'opration a chou
    objContext.SetAbort

    Err.Raise Err.Number, "WWCCHOOrder.UpdateDeliveryDate", Err.Description

    Resume UpdateDeliveryDate_Exit

End Function

