$: << File.dirname(__FILE__)
require "connect"
require "logger"
require "rubygems"
require_gem "activerecord"

#ActiveRecord::Base.logger = Logger.new(STDOUT)

#START:model
class Parent < ActiveRecord::Base
  has_many :children, :order => :position
end

class Child < ActiveRecord::Base
  belongs_to :parent
  acts_as_list  :scope => :parent_id
end
#END:model

Child.delete_all
Parent.delete_all

#START:setup
parent = Parent.new
%w{ Un Deux Trois Quatre}.each do |name|
  parent.children.create(:name => name)
end
parent.save
#END:setup

#START:display
def display_children(parent)
  puts parent.children.map {|child| child.name }.join(", ")
end
#END:display

#START:demo
display_children(parent)         #=> Un, Deux, Trois, Quatre

puts parent.children[0].first?   #=> true

two = parent.children[1]
puts two.lower_item.name         #=> Trois
puts two.higher_item.name        #=> Un

parent.children[0].move_lower
parent.reload
display_children(parent)         #=> Deux, Un, Trois, Quatre

parent.children[2].move_to_top
parent.reload
display_children(parent)         #=> Trois, Deux, Un, Quatre

parent.children[2].destroy
parent.reload
display_children(parent)         #=> Trois, Deux, Quatre
#END:demo
