$: << File.dirname(__FILE__)
require "connect"
require "logger"

#ActiveRecord::Base.logger = Logger.new(STDOUT)

require "rubygems"
require_gem "activerecord"


class Product < ActiveRecord::Base
  has_many :line_items
end

#START:line_item
class LineItem < ActiveRecord::Base
  belongs_to :product, :counter_cache => true
end
#END:line_item

LineItem.delete_all
Product.delete_all

#START:count_issue
product = Product.create(:title => "Programming Ruby",
                         :date_available => Time.now)

line_item = LineItem.new
line_item.product = product
line_item.save

puts "Taille en mmoire = #{product.line_items.size}"
puts "Taille actualise = #{product.line_items(:refresh).size}"
#END:count_issue



LineItem.delete_all
Product.delete_all

#START:count_fix
product = Product.create(:title => "Programming Ruby", 
                         :date_available => Time.now)
product.line_items.create

puts "Taille en mmoire = #{product.line_items.size}"
puts "Taille actualise = #{product.line_items(:refresh).size}"
#END:count_fix



