$: << File.dirname(__FILE__)
require "connect"
require "logger"

ActiveRecord::Base.logger = Logger.new(STDOUT)

# START:define
require "rubygems"
require_gem "activerecord"
require "pp"

@params = {}
def params
  @params
end

class Order < ActiveRecord::Base
end

class LineItem < ActiveRecord::Base
end

class Product < ActiveRecord::Base
end

#START:find_first
# return an arbitrary order
order = Order.find(:first)

# return an order for Dave
order = Order.find(:first, :conditions => "name = 'Dave Thomas'")

# return the latest order for Dave
order = Order.find(:first,
                   :conditions => "name = 'Dave Thomas'", 
                   :order      => "id DESC")
#END:find_first

#START:find_by_sql1
orders = LineItem.find_by_sql("select line_items.* from line_items, orders " +
                              " where order_id = orders.id                 " +
                              "   and orders.name = 'Dave Thomas'          ")
#END:find_by_sql1


#START:find_by_sql2
orders = Order.find_by_sql("select name, pay_type from orders")

first = orders[0]
p first.attributes
p first.attribute_names
p first.attribute_present?("address")
#END:find_by_sql2

Product.delete_all
LineItem.delete_all
p = Product.create(:title => "Programming Ruby", :date_available => Time.now)
LineItem.create(:quantity => 2, :unit_price => 44.95, :product_id => p.id)

#START:find_by_sql3
items = LineItem.find_by_sql("select *,                                  " +
                             "       quantity*unit_price as total_price, " +
                             "       products.title as title             " +
                             "  from line_items, products                " +
                             " where line_items.product_id = products.id ")
li = items[0]
puts "#{li.title}: #{li.quantity}x#{li.unit_price} => #{li.total_price}"
#END:find_by_sql3

#START:count
c1 = Order.count
c2 = Order.count(["name = ?", "Dave Thomas"])
c3 = LineItem.count_by_sql("select count(*)                        " +
                           "  from line_items, orders              " +
                           " where line_items.order_id = orders.id " +
                           "   and orders.name = 'Dave Thomas'     ")
puts "Dave a #{c3} articles (items ligne) dans  #{c2} commandes (#{c1} commandes au total)"
#END:count

#START:dynamic1
order  = Order.find_by_name("Dave Thomas")
orders = Order.find_all_by_name("Dave Thomas")
order  = Order.find_all_by_email(params['email'])
#END:dynamic1

o = LineItem.find(:all,
                  :conditions => "pr.title = 'Programming Ruby'",
                  :joins => "as li inner join products as pr on li.product_id = pr.id")
p o.size


res = Order.update_all("pay_type = 'wibble'")
p res

res = Order.delete_all(["pay_type = ?", "wibble"])
p res
