require "rubygems"
require_gem "activerecord"

require 'connect'

ActiveRecord::Base.logger = Logger.new(STDOUT)


class Order < ActiveRecord::Base
end

class Payment < ActiveRecord::Base
end

class Refund < ActiveRecord::Base
end

#START:observer
class OrderObserver < ActiveRecord::Observer
  def after_save(an_order)
    an_order.logger.info("Commande #{an_order.id} cre")
  end
end

OrderObserver.instance
#END:observer

#START:multi_observer
class AuditObserver < ActiveRecord::Observer

  observe Order, Payment, Refund

  def after_save(model)
    model.logger.info("#{model.class.name} #{model.id} cr")
  end
end

AuditObserver.instance
#END:multi_observer


o = Order.create
p = Payment.create

