class StoreController < ApplicationController
  
  def index
    @products = Product.salable_items
  end

  #START:add_to_cart
  def add_to_cart
    product = Product.find(params[:id])
    @cart = find_cart
    @cart.add_product(product)
    redirect_to(:action => 'display_cart')
  rescue
    logger.error("Tentative d'accès à un produit invalide #{params[:id]}")
    flash[:notice] = 'Produit invalide'
    redirect_to(:action => 'index')
  end
  #END:add_to_cart
  
  #START:display_cart
  def display_cart
    @cart = find_cart
    @items = @cart.items
    if @items.empty?
      flash[:notice] = "Votre panier est actuellement vide"
      redirect_to(:action => 'index')
    end
  end
  #END:display_cart



#START:cart  
  private
#END:cart

  # Renvoie un objet panier. Si le panier existe déjà dans le cache 
  # alors on l'assigne à cette variable, sinon on en crée un nouveau
  # et on l'ajoute à la session
#START:cart
  def find_cart
    session[:cart] ||= Cart.new
  end
#END:cart

end
