class Cart

  attr_reader :items
  attr_reader :total_price
  
  def initialize
    @items = []
    @total_price = 0.0
  end

  # add a product to our list of items. If an item already
  # exists for that product, up the count instead
  #START:add_product
  def add_product(product)
    item = @items.find {|i| i.product_id == product.id}
    if item
      item.quantity += 1
    else
      item = LineItem.for_product(product)
      @items << item
    end
    @total_price += product.price
  end
  #END:add_product
end

