class StoreController < ApplicationController
  
  def index
    @products = Product.salable_items
  end

  #START:add_to_cart
  #START:redirect
  def add_to_cart
    product = Product.find(params[:id])
    @cart = find_cart
    @cart.add_product(product)
    redirect_to(:action => 'display_cart')
  rescue
    logger.error("Tentative d'accès à un produit invalide #{params[:id]}")
    redirect_to_index('Produit invalide')
  end
  #END:add_to_cart

  def display_cart
    @cart = find_cart
    @items = @cart.items
    if @items.empty?
      redirect_to_index("Votre panier est actuellement vide")
    end
  end


  #START:empty_cart
  def empty_cart
    @cart = find_cart
    @cart.empty!    #<wtf linkend="wtf.name.bang">empty!</wtf>
    redirect_to_index('Votre panier est maintenant vide')
  end
  #END:empty_cart

  #END:redirect

#START:redirect
  private   # <wtf linkend="wtf.private">private</wtf>
#END:redirect

  # Renvoie un objet panier. Si le panier existe déjà dans le cache 
  # alors on l'assigne à cette variable, sinon on en crée un nouveau
  # et on l'ajoute à la session
  def find_cart
    session[:cart] ||= Cart.new
  end


  # Renseigne le flash si un paramètre est transmis
  # puis redirige vers la liste des produits
#START:redirect
  def redirect_to_index(msg = nil)
    flash[:notice] = msg if msg
    redirect_to(:action => 'index')
  end
#END:redirect
end
