class Cart

  attr_reader :items
  attr_reader :total_price
  
  #START:refactor
  def initialize
    empty!
  end

  #END:refactor

  # Ajoute un produit  la liste des articles du panier. Si l'article
  # est dj prsent, la quantit est augmente de un au lieu de
  # crer une nouvelle entre. 
  def add_product(product)
    item = @items.find {|i| i.product_id == product.id}
    if item
      item.quantity += 1
    else
      item = LineItem.for_product(product)
      @items << item
    end
    @total_price += product.price
  end

  #START:refactor
  #START:empty
  def empty!
    @items = []
    @total_price = 0.0
  end
  #END:empty
  #END:refactor
end

